/* $Id$
   Copyright 1994 TipTop Software
*/
#import <libc.h>
#import <syslog.h>
#include <pwd.h>

#define MAILSPOOL "/usr/spool/mail"

static int mkdirs(char *dir, int mode)
{
  if(access(dir,F_OK)) {
    int ret=0;
    char *slash=rindex(dir,'/');
    if(slash) {
      *slash='\0';
      ret=mkdirs(dir,mode);
      *slash='/';
    }
    if(!ret) ret=mkdir(dir,mode);
    return ret;
  }
  return 0;
}
 
static char *quote(const char *str)
{
  char *result;
  int needsquote=0;
  int i, j, len;

  if(!str) return NULL;
  len=strlen(str);

  for(i=0;i<len;i++) 
    switch(str[i]) {
    case '\'': case '\t': case '\n': case '\r': case '>': case '<': 
    case '(': case ')': case '&': case ';': case '\\': case ' ':
      if(!needsquote) needsquote=1;
      break;
    case '"': 
    case '$':
      needsquote++; break;
    }

  if(needsquote==0) {
    result=malloc(len+1);
    strcpy(result,str);
    return result;
  }

  result=malloc(len+1+needsquote);

  result[0]='"'; j=1;
  for(i=0;i<len;i++) {
    switch(str[i]) {
    //case '\'': case '\t': case '\n': case '\r': case '>': case '<': 
    //case '(': case ')': case '&': case ';': case '\\': case ' ': break;
    case '"': 
    case '$':
      result[j++]='\\';
    default:
      result[j++]=str[i];
    }
  }
  result[j++]='"';
  result[j++]='\0';
  return result;
}

int main(int argc, char *argv[])
{
  int i;
  FILE *f;
  int c;
  char dir[MAXPATHLEN+1];
  char filename[MAXPATHLEN+1];
  char *tmp;

  time_t t0;
  struct tm *t1;
  char timenow[100];

  openlog("TTSendmailFilter", LOG_CONS|LOG_PID, LOG_DAEMON);
  
  sprintf(dir,"%s/%s.outgoing",MAILSPOOL,getpwuid(getuid())->pw_name);
  mkdirs(dir,0700);

  t0=time(0);
  t1=localtime(&t0);
  strftime(timenow,sizeof(timenow)-1,"%y%m%d:%H%M%S",t1);

  sprintf(filename,"%s/Mailout.%s.XXXXXX",dir,timenow);

  f=fdopen(mkstemp(filename),"w");
  if(!f) {
    syslog(LOG_ERR, "Could not create temporary file.");
    exit(1);
  }

  /* We may want to check if there are any messages to local users.
     In that case we may want to run /usr/lib/sendmail. */

  // Put all the arguments to sendmail in the first line.
  for(i=1;i<argc;i++)
    if((tmp=quote(argv[i]))) {
      fprintf(f," %s",tmp);
      free(tmp);
    }
  fprintf(f,"\n");

  // Copy the rest of the message, header and body.
  for(;;) {
    c=fgetc(stdin);
    if(c<0) break;
    fputc(c,f);
  }
  fclose(f);    

  /* Now, we may want to signal to TipTop to dial out, log in (if
     necessary), and run the SendMail TCL procedure. */  

  exit(0);
}

// EOF
