/*

  Ronin Consulting, Inc.
    Copyright (C) 1992, Nicholas Christopher (nwc@gun.com)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
/*
** Defaults.m,v 1.1.1.1 1992/08/18 14:34:21 nwc Exp
**
*/

#import "Defaults.h"
#import <appkit/Application.h>

@implementation Defaults

static id  theOnlyOne = nil;
static NXDefaultsVector noDefs = {{NULL}};

+ new
{
   if(!theOnlyOne)
   {
      theOnlyOne = self = [super new];
      appName = [NXApp appName];
      registered = NO;
   }
   else
       self = theOnlyOne;
   
   return self;
}


- regDefaults:(NXDefaultsVector) defaultsVector
{
   NXRegisterDefaults(appName, defaultsVector);
   registered = YES;
   return self;
}


- (const char *)get: (const char *) aDefault
{
   if(!registered)
       [self regDefaults: noDefs];

   return NXGetDefaultValue(appName, aDefault);
}

- set: (const char *) aDefault to: (const char *)aValue
{
   if(!registered)
       [self regDefaults: noDefs];

   NXSetDefault(appName, aDefault, aValue);
   return self;
}

- (const char *) readDB: (const char *) aDefault
{
   if(!registered)
       [self regDefaults: noDefs];

   return NXReadDefault(appName, aDefault);
}

- writeDB: (const char *) aDefault as: (const char *)aValue
{
   if(!registered)
       [self regDefaults: noDefs];

   NXWriteDefault(appName, aDefault, aValue);
   return self;
}


- remove: (const char *) aDefault
{
   if(!registered)
       [self regDefaults: noDefs];

   NXRemoveDefault(appName, aDefault);
   return self;
}

- update: (const char *) aDefault
{
   if(!registered)
       [self regDefaults: noDefs];

   NXUpdateDefault(appName, aDefault);
   return self;
}

- update
{
   if(!registered)
       [self regDefaults: noDefs];

   NXUpdateDefaults();
   return self;
}


@end


