/*

  Ronin Consulting, Inc.
    Copyright (C) 1992, Nicholas Christopher (nwc@gun.com)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
#import "Subprocess.h"
#import "EnhancedText.h"
#import "LogController.h"
#import "StringStorage.h"
#import <appkit/appkit.h>
 
static float offsetCoord = 0.0;

@implementation LogController

- makeKeyAndOrderFront:sender
{
   char	path[MAXPATHLEN+1];
   NXRect theFrame;
   
   if(!window)
   {
      if(![[NXBundle mainBundle] getPath:path forResource:"LogController" ofType:"nib"])
      {
	 NXLogError("Could not find LogController.nib");
	 return self;
      }
      

      if(![NXApp loadNibFile: path owner: self])
      {
	 NXLogError("Could not load LogController.nib");
	 return self;
      }
      
      NXLogError("makeKeyAndOrderFront called for %s", [cmd stringValue]);
      subProc = [[Subprocess alloc] init: [cmd stringValue] withDelegate: self];
   }
   
   if(![window setFrameUsingName: [name stringValue]]) /* see if we save the window position... */
   {
      [window getFrame: &theFrame];	     /* if not just offset from last window some */
      [window moveTo: theFrame.origin.x + offsetCoord : theFrame.origin.y - offsetCoord];
      offsetCoord += 10;
   }
   [window setFrameAutosaveName: [name stringValue]];
   [window setTitle: [name stringValue]];
   [window makeKeyAndOrderFront: self];
   
   return self;
}

- initForCommand: (const char *)cmdStr entitled: (const char *)myName;
{
   [super init];
   window = nil;
   cmd = [[StringStorage alloc] init: cmdStr];
   name = [[StringStorage alloc] init: myName];
   return self;
}

- free
{
   if(subProc)
       [subProc free];

   [cmd free];
   [name free];
   return [super free];
}

       
- logClear
{
   [logView empty: self];
   return self;
}

@end


@implementation LogController (SubprocessDelegate)

- subprocess:sender done:(int)exitStatus
{
   [logView appendString: "tail exited... yips!\n"];
   return self;
}

- subprocess:sender output:(char *)buffer
{
   [logView appendString: buffer];
   [logView appendString: "\n"];
   return self;
}

- subprocess:sender stderrOutput:(char *)buffer
{
   [logView appendString: buffer];
   [logView appendString: "\n"];
   return self;
}

- subprocess:sender error:(const char *)errorString
{
   [logView appendString: "tail failed to start."];
   return self;
}


@end					     /* SubprocessDelegate */

