/*

  Ronin Consulting, Inc.
    Copyright (C) 1992, Nicholas Christopher (nwc@gun.com)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
#import <appkit/Application.h>
#import <appkit/Window.h>
#import <appkit/Cell.h>
#import "Defaults.h"
#import "PrefController.h"

static NXDefaultsVector myDefaults =
{
{"DefaultHost", ""},
{"DebugPoll", "NO"},
{"ShowLog", "NO"},
{"ShowSysLog", "NO"},
{"BaudRate", "1200"},
{NULL}
};



@implementation PrefController

- init
{
   [super init];
   defaults = [Defaults new];
   [defaults regDefaults: myDefaults];
   return self;
}

- makeKeyAndOrderFront:sender
{
   if(!window && ![NXApp loadNibSection: "Preferences.nib" owner: self])
   {
      return self;
   }

   [self revert: self];
   [window display];
   [window makeKeyAndOrderFront: self];
   return self;
}

- revert: sender
{

   if(*[defaults get: "DebugPoll"] == 'Y')
       [debugPolling setState: YES];
   else
       [debugPolling setState: NO];

   if(*[defaults get: "ShowLog"] == 'Y')
       [showLog setState: YES];
   else
       [showLog setState: NO];

   if(*[defaults get: "ShowSysLog"] == 'Y')
       [showSysLog setState: YES];
   else
       [showSysLog setState: NO];

   [defaultHost setStringValue: [defaults get: "DefaultHost"]];
   [baudRate setStringValue: [defaults get: "BaudRate"]];

   return self;
}


- ok:sender
{
   if([debugPolling state])
       [defaults writeDB: "DebugPoll" as: "YES"];
   else
       [defaults writeDB: "DebugPoll" as: "NO"];


   if([showLog state])
       [defaults writeDB: "ShowLog" as: "YES"];
   else
       [defaults writeDB: "ShowLog" as: "NO"];

   if([showSysLog state])
       [defaults writeDB: "ShowSysLog" as: "YES"];
   else
       [defaults writeDB: "ShowSysLog" as: "NO"];

   [defaults writeDB: "DefaultHost" as: [defaultHost stringValue]];
   [defaults writeDB: "BaudRate" as: [baudRate stringValue]];

   [window performClose: self];
   return self;
}

- windowDidBecomeKey: sender
{
   [self revert: self];
   return self;
}


@end
