/*
  Copyright (c) 1992, Nicholas Christopher (nwc@gun.com)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "StringStorage.h"
#import <string.h>

static char EOS = (char)0;

@implementation StringStorage

- init
{
   [self init: ""];
   return self;
}

- init: (const char *) str
{
   [super init];
   
   [self initCount: 0 elementSize: sizeof(char) description: "c"];
   [self setStringValue: str];
   return self;
}

- setStringValue: (const char *) str;
{
   int len;

   if(!str)
       str = "";			     /* avoid nil strings */

   len = strlen(str);			     /* get length - no reason to do it twice */
   [self setNumSlots: len + 1];		     /* use setNumSlots vs setAvailCapacity since it sets count */

					     /* bcopy is far faster than strcpy if the length is known */
   bcopy(str, (char *)dataPtr, len); 
   [self replaceElementAt: len with: (char *)&EOS];
   return self;
}

- (const char *) stringValue
{
   return dataPtr;
}

- appendStringValue: (const char *)str
{
   int oldCount = [self count];
   int len;

   if(!str || !*str)			     /* nothing to append */
       return self;
   
   len = strlen(str);			     
   [self setNumSlots: oldCount + len];
   bcopy(str, (char *)[self elementAt: oldCount - 1], len);
   [self replaceElementAt: oldCount + len - 1 with: (char *)&EOS ];
   return self;
}

- appendCharValue: (char) c
{
   char buf[2];
   
   buf[0] = c;
   buf[1] = (char)0;

   [self appendStringValue: buf];

   return self;
}

@end
