/*

  Ronin Consulting, Inc.
    Copyright (C) 1992, Nicholas Christopher (nwc@gun.com)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
#import "SweepView.h"
#import "sweep.h"
#import <c.h>

@implementation SweepView

+ initialize
{
   [self setVersion: 1];
   return self;
}

- initFrame:(const NXRect *)frameRect
{
   [super initFrame:frameRect];
   total = 360;
   stepSize = 1;
   return self;
}


- drawSelf:(const NXRect *)rects :(int)rectCount
{
   float circleX, circleY, circleRad;

   circleRad = (MIN(rects->size.width,rects->size.height) - 2.0)/2.0;
   circleX = (rects->size.width/ 2.0) + rects->origin.x;
   circleY = (rects->size.height/ 2.0) + rects->origin.y;
   PSWsweep(circleX, circleY, circleRad, ratio * (float)total);

   return self;
}

- increment: sender   
{
    count += stepSize;
    count %= total;

    [self setRatio:(float)count/(float)total];
    return self;
}



@end

