/*
	setup.c
	
	version	: 1.01.0
	date	: 27.Nov
	author	: jolly ( who else )
	purpose	: a simple answering machine setup environment

*/

#import <libc.h>
#import <sys/param.h> // defines MAXPATHLEN

#import "../src/precomp.h"

/************************************************************************/
/* This is the main file for your own answering machine / voice mailbox */
/************************************************************************/


#define SYS_DIR		"System"
#define NEW_DIR		"New_Ones"
#define SND_DIR		"New_Ones_Snd"

#define	OLD_DIR		"Old_Ones"

#define WELCOME		"Welcome"
#define S_MAXTIME	"System/Maxtime"
#define S_ERROR		"System/Error"
#define S_OK		"System/Ok"

#define P_FRIEND	1234
#define	S_FRIEND	"System/FooBar"

#define P_ROOT		4321			/* password to hear all messages 	NO LEADING ZERO'S*/
#define R_ACCEPT	"System/RootOk"
#define R_MENU		"System/RootMenu"



void main_loop(void)
{
	int		password;
	char	rec_name[MAXPATHLEN];
	char	timename[100];

	play_message(WELCOME);
	play_beep();
	do
	{
		sprintf(rec_name,"%s/%s",NEW_DIR,get_time(timename));
		switch(password=record_message(rec_name))
		{
			case P_ROOT		:	remove_message(rec_name);root_menu();password=0;break;
			case P_FRIEND	:	play_message(S_FRIEND);break;
			case MAXTIME	:	play_message(S_MAXTIME);cnv_snd(NEW_DIR,SND_DIR,timename);return;
			case EOC		:	cnv_snd(NEW_DIR,SND_DIR,timename);return;
			default			:	remove_message(rec_name);play_message(S_ERROR);
		}
	}
	while(password>0);
}



#define RM_MOM1			"tmp/r_mom1"
#define RM_MOM2			"tmp/r_mom2"
#define RM_MENU			"System/R_Menu"
#define RM_ACCEPT		"System/R_Accept"
#define RM_LISTENOLD	2
#define RM_NWW_RECORD	4
#define RM_NWW_LISTEN	6
#define RM_NWW_INSTALL	8

void root_menu(void)
{
	char mom[MAXPATHLEN*2];
	int pwd;
	
	play_message(RM_ACCEPT);
	play_all(NEW_DIR);
	sprintf(mom,"mv %s/* %s",NEW_DIR,OLD_DIR);
	system(mom);

	sprintf(mom,"mv %s %s",RM_MOM2,WELCOME);
	do
	{
		play_message(RM_MENU);
		switch(pwd=record_message(RM_MOM1))
		{
			case RM_LISTENOLD	:	play_all(OLD_DIR);break;
			case RM_NWW_RECORD	:	remove_message(RM_MOM2);play_message(S_OK);
									play_beep();record_message(RM_MOM2);break;
			case RM_NWW_LISTEN	:	play_message(RM_MOM2);break;
			case RM_NWW_INSTALL	:	system(mom);play_message(S_OK);break;
			default				:	play_message(S_ERROR);
		}
		remove_message(RM_MOM1);
	}
	while(pwd>0);

}






