/*	TEXT WAS MADE WITH 4*SPACE = 1*TAB

	program	:	am.c
	version	:	see the version.h file	
	date	:	27.November 1993
	purpose	:	simulate an answering machine with fax- and datacall capabilities 
	author	:	by jolly ( who else )

*/


int	modem; 			// fildes of modem 
int	timerstatus;	// sigalarm timerstatus for recording and playing
int	realtime;		// sigalarm timer for recording and playing

#import <libc.h>
#import "precomp.h"

int main(void)
{	
	int	tty;
	
	signal(SIGALRM	,(void *)sig_alrm);
	signal(SIGINT	,(void *)sig_fatal);
	signal(SIGTERM	,(void *)sig_fatal);
	
	if(chdir(PATH)==-1)
		fatal("Can't change working directory to %s\n",PATH);
	tty=open("/dev/tty",O_RDWR);
	ioctl(tty, TIOCNOTTY, 0);
	close(STD_IN);
	close(STD_OUT);
	close(STD_ERR);
#if DEBUG
	log("*** Answering Machine started ***");
#endif
	while(1) wait_for_call();
}


void wait_for_call(void)
{
	int		nfds=1;
	fd_set fdset;
	

	do
	{
		do
		{	
			open_line(DIAL_OUT);
			reset_modem();
			unlock_line(DIAL_OUT);
			wait_for("XXX",200);
			FD_ZERO(&fdset);
			FD_SET(modem,&fdset);
			select(nfds,&fdset,NULL,NULL,NULL);
		}
		while( tst_lock() && close_line(DIAL_OUT));
		
		if(wait_for("NO CARRIER",100))
		{
			ask("AT+FCLASS=8","OK");
			say("ata");
		}
		else
		{
			ask("AT+FCLASS=8","OK");
			ask("ATS0=%d","OK",RING);
		}
	}
	while( !wait_for("VCON",20000) && close_line(DIAL_OUT) );
	
	main_loop();
	
	reset_modem();
	close_line(DIAL_OUT);
}





/*************************************************************************************nifty fncts */


int rec_message(char *name)
{
	static char		*buf=NULL;
	FILE 			*feil;
	static struct	zyxel		header;
	static struct	itimerval	alrm,oalrm;
	int 			pass=0;
	char			*i,*prev,*bend;

	if(buf==NULL)
	{
		buf=(char *)malloc(sizeof(char)*BSIZE+2);
		*buf++=DLE;	// the -1 byte is DLE for easy handle with overlappin' blocks
		strcpy(header.title,"ZyXEL");
		header.mode=ZYX_VOC;
		switch(SPEECH)
		{
			case ADPCM_3	:header.voice=ZYX_AD3;break;
			case ADPCM_2	:header.voice=ZYX_AD2;break;
			case CELP		:header.voice=ZYX_CLP;break;
			default			:header.voice=ZYX_AD2;break;
		}
	}

	if((feil=fopen(name,"w"))==NULL)
		fatal("Can't open File :%s",name);
	fwrite(&header,sizeof(struct zyxel),1,feil);

	ask("at+vsd=%d,%d","OK",SIL_TRES,SIL_TIME*10);
	ask(ATSP,"OK");
	ask("at+vrx","CONNECT\r\n");
#if DEBUG
	log("recording message : %s",name);
#endif

	siginterrupt(SIGALRM,1);
	alrm.it_interval.tv_sec=0;
	alrm.it_interval.tv_usec=1000000/RPS;	
	alrm.it_value.tv_sec=0;
	alrm.it_value.tv_usec=1000000/RPS;
	if(setitimer(ITIMER_REAL,&alrm,&oalrm)==-1)
		fatal("error creating timer\n");

	timerstatus	=T_REC;
	realtime	=0;
	prev		=buf;
	do
	{	
		do
		{
			sigpause(SIGALRM);
			if(timerstatus==T_STP) {fclose(feil);ask("\x10\x03","VCON");return MAXTIME;}
			bend=buf+read(modem,buf,BSIZE);
		}
		while(bend<=buf);
		*bend=DLE;
		
		for(i=prev;i<bend;i++)
		{
			if(*i==DLE)
			{		
				if(i>prev) fwrite(prev,1,i-prev,feil); 
				prev=++i+1;
#if DEBUG 
				if(*i>32) log("REC time=%d  %c=%x",realtime,(char)*i,(char)*i);
#endif
				switch(*i)
				{
					case 's' 	:{fclose(feil);	ask("\x10\x03","VCON");return SILENCE;}
					case 'q' 	:{fclose(feil);	ask("\x10\x03","VCON");return QUIET;}
					case '*' 	:{fclose(feil);	ask("\x10\x03","VCON");return (pass)?pass:STAR;}
					case '#' 	:pass=0;break;
					case '1'	:pass=pass*10+1;break;
					case '2'	:pass=pass*10+2;break;
					case '3'	:pass=pass*10+3;break;
					case '4'	:pass=pass*10+4;break;
					case '5'	:pass=pass*10+5;break;
					case '6'	:pass=pass*10+6;break;
					case '7'	:pass=pass*10+7;break;
					case '8'	:pass=pass*10+8;break;
					case '9'	:pass=pass*10+9;break;
					case '0'	:pass=pass*10;break;
					case 'c'	:{fclose(feil);	ask("\x10\x03","VCON");return FAX;}
					case 'b'	:{fclose(feil);	ask("\x10\x03","VCON");return BUSY;}
					case 'h'	:{fclose(feil);	ask("\x10\x03","VCON");return HANG_UP;}
					case ETX	:{fclose(feil);return EOS;}
					default		:prev=i-1;break;
				}
			}
		}
		if(*(bend-1)==DLE)
			prev=buf-1;
		else
		{
			if(bend>prev)	fwrite(prev,1,bend-prev,feil);		
			prev=buf;
		}
		
	}
	while(1);
	return 0;	// never reached
}





int ply_message(char *name)
{
	char *snd;
	FILE *feil;
	int mfl;
	int pwd;
	
	static char a_name[200];
	static struct zyxel header;
		
	strcpy(a_name,name);
	strcat(a_name,Z_EXT);

	if((feil=fopen(a_name,"r"))==NULL)
	{
		log("Can't play Message :%s",a_name); 
		return Z_ERROR;
	}
#if DEBUG
	log("Playing Message :%s",a_name);
#endif
	fseek(feil,0L,SEEK_END);
	mfl=ftell(feil);
	rewind(feil);

	snd=(char *)malloc(sizeof(char)*mfl-sizeof(struct zyxel));
	fread(&header,sizeof(struct zyxel),1,feil);
	fread(snd,1,mfl,feil);
	fclose(feil);

	switch(isZyXEL(&header))
	{
		case ZYX_AD3		:ask("at+vsm=3","OK");break;
		case ZYX_AD2		:ask("at+vsm=2","OK");break;
		case ZYX_CLP		:ask("at+vsm=1","OK");break;
		case ZYX_NOSNDHEADER:return log("File:%s is not a voice file",name);
		default				:return log("File:%s voice format not supported",name);
	}		

	ask("at+vtx","CONNECT\r\n");
	pwd=block_write(snd,mfl);
	if(pwd==FAX)
		{
			free(snd);
			ask("\x10\x03","VCON");
#if DEBUG
			log("Deteced Fax while playing a message");
#endif
			try_fax_connection(NULL);
			return FAX;
		}
	ask("\x10\x03","VCON");
	free(snd);
	return pwd;
}



int try_data_connection(char *rec_name)
{		
	ask("at+fclass=0","OK");
	ask("at&n0&d0&c0s2=32","OK");
	close_line(DIAL_OUT);
	open_line(DIAL_CONNECT);
	ask("at&d3","OK");
	say("ata");

	if( (realtime<(SIL_TIME+5)*RPS) && wait_for("CONNECT",MAX_CD*1000)) 
	{	
		char c=32;
#if DEBUG
		log("Got Data Connection");
#endif
		remove(rec_name);
		write(modem,&c,1);usleep(500);
		write(modem,&c,1);usleep(500);
		write(modem,&c,1);usleep(500);
		wait_for("OK",2000);
		ask("at&c1","OK");
		ask("ats2=255","OK");
		say("ato");
		execle("/usr/etc/getty","/usr/etc/getty",GETY,NULL,NULL);
		exit(1);
	}
	else
	{
		FILE	*feil;
		char	*tmp;
		long	len;
#if DEBUG
		log("Got no Data Connection");
#endif

		feil=fopen(rec_name,"r");
		if(feil==NULL)
		{
			log("failed fopen can't open messagefile %s for reading",rec_name);
			return Z_ERROR;
		}
		fseek(feil,0L,SEEK_END);
		len=ftell(feil)-( (SIL_TIME)*BPS+(BPS/2) );
		if(len<0)
		{
			fclose(feil);
			remove(rec_name); // never again - this fuckin people that hangup after the welcome message !
		}
		else
		{
			rewind(feil);
			tmp=(char *)malloc(sizeof(char)*len+1);
			if(!tmp)
			{
				log("Cant alloc enough memory");
				return Z_ERROR;
			}
			fread(tmp,1,len,feil);
			fclose(feil);
			remove(rec_name);
			feil=fopen(rec_name,"w");
			if(feil==NULL)
			{
				log("failed fopen can't open messagefile %s for writeing",rec_name);
				return Z_ERROR;
			}
			fwrite(tmp,1,len,feil);
			fclose(feil);
			free(tmp);
		}
	}
	return EOC;
}




int try_fax_connection(char *rec_name)
{	
	
	ask("at+flid=%s","OK",FAXNUMBER);
	ask("at#l2#c7","OK");
	ask("atx7#b0+fclass=6","OK");
	say("ata");
	if(wait_for("CONNECT FAX",MAX_FD*1000) ) // && wait_for("ZyXEL\r\n",MAX_FD*1000) ) 
	{	
#if DEBUG
		log("Got Fax Connection");
#endif
		if(rec_name!=NULL) remove(rec_name);
		//write(modem,&dc2,1);
		recv_fax();				
	}
	exit(0);
	return 0;
}


int	recv_fax()
{
	FILE			*tmpfeil;
	static	char	tmpname[MAXPATHLEN];
	static struct	itimerval alrm,oalrm;
	int				blen;
	int 			i=0,flg=0;
	char			str[BSIZE];
	char			*buf=NULL;
	
	char			mstr[100];
	int				mlen;
	
	if(buf==NULL)
	{
		buf=(char *)malloc(sizeof(char)*BSIZE+1);
		*buf++=DLE;	// the -1 byte is DLE for easy handle with overlappin' blocks
	}

	siginterrupt(SIGALRM,0);
	alrm.it_interval.tv_sec=0;
	alrm.it_interval.tv_usec=1000000/RPS;	
	alrm.it_value.tv_sec=0;
	alrm.it_value.tv_usec=1000000/RPS;
	if(setitimer(ITIMER_REAL,&alrm,&oalrm)==-1)
		fatal("error creating timer");

	realtime=0;	
	sigpause(SIGALRM);
	blen=read(modem,buf,BSIZE);
	i+=10; // search not the first chars 
	while( buf[i++]!='\r' && i<blen);
	if(i==blen) return 0;			//first read should be succsessfull ... if not - bad luck P(
	
	buf[i]=0;
	strcpy(str,buf);
		
	blen-=(i-3);
#if NeXTSTEP > 30
	buf[i]='1';
#else
	buf[i]='0';
#endif
	buf[i-1]='0';
	buf[i-2]='0';
	
	tmpfeil=fopen("tmpfax.fax","w");
	fclose(tmpfeil);

	tmpfeil=fopen("tmpfax.001","w");
	fwrite(buf+i-2,blen,sizeof(char),tmpfeil);
	
	strcpy(mstr,"NO CARRIER");
	mlen=strlen(mstr);
	do
	{
		do
		{
		sigpause(SIGALRM);
		blen=read(modem,buf,BSIZE);
		}
		while(blen<1);
		
		for(i=0;i<blen;i++)
		{
			if( buf[i] == mstr[flg] )
			{
				flg++;
				if(flg==mlen) mlen=-1;
			}
			else
				flg=0;
		}
		fwrite(buf,blen,sizeof(char),tmpfeil);
	}
	while(mlen>0 && realtime<RPS*MAX_FAXTIME);
	
	fclose(tmpfeil);
#if DEBUG
	log("Got FaxDisconnect message");
#endif
	alrm.it_interval.tv_sec=0;
	alrm.it_interval.tv_usec=0;
	alrm.it_value.tv_sec=0;
	alrm.it_value.tv_usec=0;
	if(setitimer(ITIMER_REAL,&alrm,&oalrm)==-1)
		fatal("error removing timer");

	switch(vfork())
	{
		case 0	:	execle("/usr/lib/NextPrinter/faxcleanup","faxcleanup","1","tmpfax",NULL,NULL);exit(1);break;
		case -1	:	fatal("Can't fork \n");break;
		default :	wait( (union wait*)0);
	}
	
	sprintf(tmpname,"%s/%s.fax",FAX_DIR,get_time(str));
#if DEBUG
	log("tmpname now :%s",tmpname);
#endif
	rename("tmpfax.fax",tmpname);
#if DEBUG < 2
	remove("tmpfax.ctl");
	remove("tmpfax.001");
#endif
	wait_for("XXX",200);
	say("ATZ4");
	wait_for("OK",900);
	exit(0);
}



/*************************************************************************************low level fncts */

int wait_for(char *s,long t)
{
	static char tst[100];
	static struct itimerval alrm,oalrm;
	int b=0,a=0,ok,flg=0,len;

	siginterrupt(SIGALRM,1);
	alrm.it_interval.tv_sec=0;
	alrm.it_interval.tv_usec=0;
	alrm.it_value.tv_sec=t/1000;
	alrm.it_value.tv_usec=(t%1000)*1000;
	if(setitimer(ITIMER_REAL,&alrm,&oalrm)==-1)
		fatal("error creating timer");

	flg=0;
	len=strlen(s);
	tst[len]=0;
	ok=0;
	do
	{
		a=read(modem,tst+((++b)%len),1);
		if(a==-1)
		{
			flg=1;
		}
		else
		{
			if(tst[b%len]==s[ok]) ok++;
			else ok=0;
		}
	}
	while(ok!=len && !flg);
	alrm.it_value.tv_sec=0;
	alrm.it_value.tv_usec=0;
	if(setitimer(ITIMER_REAL,&alrm,&oalrm)==-1)
		fatal("error removing timer");

#if DEBUG > 1
	log("Waited for (%s) got (%s) == %s time=%d",s,tst,ok?"YES":"NO",oalrm.it_value.tv_usec);
#endif
	return ok;
}



int block_write(char * snd,int size)
{
	int 	i=0,a,pass=0;
	static 	struct itimerval alrm,oalrm;
	char	c;
		
	siginterrupt(SIGALRM,1);
	alrm.it_interval.tv_sec=0;
	alrm.it_interval.tv_usec=1000000/PPS;
	alrm.it_value.tv_sec=0;
	alrm.it_value.tv_usec=1000000/PPS;
	if(setitimer(ITIMER_REAL,&alrm,&oalrm)==-1)
		fatal("error creating timer");
	
	realtime	=PPS;
	timerstatus	=T_PLY;
	do
	{
		if((size-i)>=BPP)
			a=write(modem,snd+i,BPP);
		else
			a=write(modem,snd+i,size-i);			
		if(a>0)
			i+=a;
		else log("block written - somethin lost");


		if( (realtime*BPP<i) && (read(modem,&c,1)==1) )
		{
			if(c==DLE)
			{
				read(modem,&c,1);
#if DEBUG 
				if(c>32) log("PLY time=%d  %c=%x",realtime,c,c);
#endif
				switch(c)
				{
					case '*' 	:{return (pass)?pass:STAR;}
					case '#' 	:pass=0;break;
					case '1'	:pass=pass*10+1;break;
					case '2'	:pass=pass*10+2;break;
					case '3'	:pass=pass*10+3;break;
					case '4'	:pass=pass*10+4;break;
					case '5'	:pass=pass*10+5;break;
					case '6'	:pass=pass*10+6;break;
					case '7'	:pass=pass*10+7;break;
					case '8'	:pass=pass*10+8;break;
					case '9'	:pass=pass*10+9;break;
					case '0'	:pass=pass*10;break;
					case 'c'	:return FAX;
					case 'b'	:return BUSY;
					case 'h'	:return HANG_UP;
					case ETX	:return EOS;
				}
			}
		}
	}
	while(i<size);

	while(realtime*BPP<i)
		sigpause(SIGALRM);

	alrm.it_interval.tv_sec=0;
	alrm.it_interval.tv_usec=0;
	alrm.it_value.tv_sec=0;
	alrm.it_value.tv_usec=0;
	if(setitimer(ITIMER_REAL,&alrm,&oalrm)==-1)
		fatal("error removing timer");
	return EOC;
}




/*************************************************************************************signals */

int sig_alrm()
{
	switch(timerstatus)
	{
		case T_REC	:if(realtime++>MAXRECTIME) timerstatus=T_STP;break;
		case T_PLY	:realtime++;break;
		case T_FAX	:realtime++;break;
	}
	return 0;
}


int sig_fatal()
{
	fatal("Signal occoured");
	return 0;
}


