/*
	am.h
	
	version	:	0.01.5
	date	:	01.April.1993
	purpose	:	a better look off am.c 
	author	:	by jolly ( who else )
	
*/

/*	TEXT WAS MADE WITH 4*SPACE = 1*TAB	*/


#define CELP	1
#define ADPCM_2	2
#define ADPCM_3	3

#define A	1
#define	B	2

#import "../config/config.h"

/******************************************** Stop to change defines below	*/

#if PORT ==  A
#define		DIAL_OUT		"/dev/cufa"
#define		DIAL_CONNECT	"/dev/ttydfa"	
#define 	LOCKFILE 		"/usr/spool/uucp/LCK/LCK.."	
#define 	LCKTST			"a"
#else
#define		DIAL_OUT		"/dev/cufb"
#define		DIAL_CONNECT	"/dev/ttydfb"	
#define 	LOCKFILE 		"/usr/spool/uucp/LCK/LCK.."	
#define 	LCKTST			"b"
#endif

#undef A	
#undef B


#if SPEECH == CELP
#define 	BPS 	9600/8
#define 	ATSP 	"at+vsm=1"
#if NeXTSTEP > 29
#warning	Using CELP speech compression on recording
#warning	There is no Convertor for CELP -> snd available
#endif


#elif SPEECH == ADPCM_2
#define 	BPS		19200/8
#define 	ATSP 	"at+vsm=2"

#else SPEECH == ADPCM_3
#define		BPS		28800/8
#define		ATSP	"at+vsm=3"
#if NeXTSTEP > 29
#warning	Using 3-bit ADPCM speech compression on recording
#warning	There is no Convertor for 3-bit ADPCM -> snd available
#endif
#endif


/*********************************** depended defines */

#define		SPD		EXTB
#define		GETY	"std.38400"

#define RPS			10			/* records per second */
#define PPS			4			/* plays per second */
#define BPP			BPS/PPS		/* bytes per play */
#define	MAXRECTIME	MAX_TIME*RPS
#define BSIZE		BPS			/* i case of systemload it's better to have a bit space*/


/************************************ indep. defines */

#define 	LCKDIR		"/usr/spool/uucp/LCK/"
#define		STD_IN		0
#define		STD_OUT		1
#define		STD_ERR		2


/************************************ MACROS */

#define say(b)			write(modem,b,strlen(b));write(modem,"\r\n",2);

/******************************************sigalarm */

#define T_STP			0
#define T_REC			1
#define T_PLY			2
#define T_FAX			3

/******************************************prototypes */

int		main(void);
void	wait_for_call(void);
int 	rec_message(char *);
int 	ply_message(char *);
int		try_data_connection(char *);
int		try_fax_connection(char *);
int		recv_fax();
int		wait_for(char *,long);
int		block_write(char *,int);
int		sig_alrm(void);
int		sig_fatal(void);

