/* 
	amlib.c
	by jolly 
*/

#import <libc.h>
#import <sys/dir.h>
#import <sys/timeb.h>
#import "precomp.h"

void ftime();

void play_beep(void)
{
		ask("at+vbt=2+vts=a","OK");
}

int play_message(char *name)
{
	static	DIR *dirp;
	static	struct direct *dp;   
	static	struct timeb tb;
	int	i=0,dlen=0;
	static	char ownname[MAXPATHLEN];
	
	strcpy(ownname,name);
	dirp = opendir(name);
	if(dirp==NULL)
		return ply_message(ownname);
	for(dp = readdir(dirp); dp != NULL; dp=readdir(dirp))
		if(dp->d_namlen>Z_EXTLEN && !strcmp(Z_EXT,dp->d_name+dp->d_namlen-Z_EXTLEN)) dlen++;
	if(dlen<1)
	{
		log("no random message");
		return Z_ERROR;
	}
	rewinddir(dirp);
	ftime(&tb);
	srandom((int)(tb.millitm));
	dlen=random()%dlen;
	for(dp = readdir(dirp); dp != NULL; dp=readdir(dirp))
		if(dp->d_namlen>Z_EXTLEN && !strcmp(Z_EXT,dp->d_name+dp->d_namlen-Z_EXTLEN) && dlen==i++)
			sprintf(ownname,"%s/%s",name,dp->d_name);
	closedir(dirp);
	ownname[strlen(ownname)-Z_EXTLEN]=0;
	return ply_message(ownname);
}



int play_all(char *name)
{
	static DIR *dirp;
	static struct direct *dp;   
	static char	ownname[MAXPATHLEN];     
	static	int	olen;
	
	strcpy(ownname,name);
	strcat(ownname,"/");
	olen=strlen(ownname);
	dirp = opendir(name);
	if(dirp==NULL)
		fatal("Directory called :%s vanished during runtime\n",name);
	for(dp = readdir(dirp); dp != NULL; dp=readdir(dirp))
	if(dp->d_namlen>Z_EXTLEN && !strcmp(dp->d_name+dp->d_namlen-Z_EXTLEN,Z_EXT))
	{
		strcpy(ownname+olen,dp->d_name);
		ownname[olen+dp->d_namlen-Z_EXTLEN]=0;
		ply_message(ownname);
	}
	closedir(dirp);
	return 0;
}


int	record_message(char *name)
{
	int		ret;
	char	newname[MAXPATHLEN];
	
	sprintf(newname,"%s%s",name,Z_EXT);
	ret=rec_message(newname);
	if(ret>0) return ret;
	switch(ret)
	{
		case FAX		: try_fax_connection(newname);exit(1);
		case SILENCE	: try_data_connection(newname);return EOC;
		case MAXTIME	: return MAXTIME;
		default			: return EOC;
	}
	return EOC;	// never reached
}


/*************************************************************************************stuff */

int	remove_message(char *name)
{
	char	newname[MAXPATHLEN];
	
	sprintf(newname,"%s%s",name,Z_EXT);
	return remove(newname);
}


char * get_time(char *str) 
{
	time_t now;

	now=time(NULL);
	strftime(str,30,"%a_%H:%M:%S",localtime(&now));
	return str;
}











