


#import <libc.h>
#import <sound/sound.h>
#import "precomp.h"

void cnv_snd(char *newdir,char *outdir,char *fname)
{
	struct	zyxel header;
	char str[MAXPATHLEN];
	char str2[MAXPATHLEN];
	FILE *feil,*infd,*outfd;
	
	feil=tmpfile();
	sprintf(str,"%s/%s%s",newdir,fname,Z_EXT);
	infd=fopen(str,"r");
	sprintf(str2,"%s/conv.snd",outdir);
	outfd=fopen(str2,"w+");
	
	fread(&header,sizeof(struct zyxel),1,infd);
	switch(isZyXEL(&header))
	{
		case ZYX_AD2		:ad2(feil,infd);lin96_to_mulaw(feil,outfd);break;
		default				:return;
	}
	
	fclose(infd);
	fclose(outfd);
	sprintf(str,"sndconvert -o %s/%s.snd -f 1 -s 8012 %s &",outdir,fname,str2);
	system(str);

	return;
}



void ad2(FILE *feil,FILE *infd)
{
	u_char	buf;
	short	sample[4];
	do
	{
		fread(&buf,1,1,infd);
		if(buf==DLE)
		{
			fread(&buf,1,1,infd);
			if(buf!=DLE) fread(&buf,1,1,infd);
		}
		sample[0]=ad2_to_lin16( (buf&0xc0)>>6);
		sample[1]=ad2_to_lin16( (buf&0x30)>>4);	
		sample[2]=ad2_to_lin16( (buf&0x0c)>>2);
		sample[3]=ad2_to_lin16( (buf&0x03) );
		fwrite(sample,sizeof(short),4,feil);
	}
	while(!feof(infd));
}


short ad2_to_lin16(u_char c)
{
		static	int M[]={0x3800,0x5600};
		static	int	A=0;
		static	int	delta=5;
		
		static	char	sign;
		static	char	data;

        sign=c>>1;
        data=c&1;
              
		delta = M[(int)data] * delta;
		delta += 0x2000 ;
		delta >>=14;
		
		if ( sign )
                A += delta ;
        else
                A -= delta ;
        
		if(A<0)
		{
			A=-A;
			A &=0x7FFF;
			A =-A;
		}
		else
		{
			A &= 0x7FFF;
		}
		
		if(delta <5) delta=5;
		return A;
}

/* */

void lin96_to_mulaw(FILE *feil,FILE *outfd)
{
	int	len;
	SNDSoundStruct	snd;
	short	sample[6];

	len=ftell(feil);
	rewind(feil);

    snd.magic		=SND_MAGIC;
    snd.dataLocation=sizeof(SNDSoundStruct);
    snd.dataSize	=(long)len/sizeof(short);    
    snd.dataFormat	= SND_FORMAT_LINEAR_16;
    snd.samplingRate=(float)9600;
    snd.channelCount=1;
    strcpy(snd.info,"jr"); // yep Jolly Roger !
	
	fwrite(&snd,sizeof(SNDSoundStruct),1,outfd);
	do
	{
		fread(sample,sizeof(short),1,feil);
		fwrite(sample,sizeof(short),1,outfd );
	}
	while(!feof(feil));

	return;
}
