/*	TEXT WAS MADE WITH 4*SPACE = 1*TAB

	program	:	modem.c	
	date	:	05.April. 1993
	purpose	:	 
	author	:	by jolly ( who else )

*/

/*************************************************************************************modem */

#import <libc.h>
#import <sys/dir.h>

#import "precomp.h"

extern int modem;


void reset_modem(void)
{
#if DEBUG
	log("resetting modem");
#endif
	ioctl(modem,TIOCCDTR,NULL);
	say("\x10\x03\n\x10\x03\nYYY");wait_for("XXX",500);
	ioctl(modem,TIOCSDTR,NULL);
	ask("ATZ4","OK");
	ask("AT+FCLASS=0","OK");
	ask("at&D3&N0&S1E1S0=0","OK");
}


int tst_lock(void)
{
	DIR 	*dirp;
	struct direct *dp;        
	int 	lckfeil,pid=0;
	char 	lck[MAXPATHLEN];

	dirp = opendir(LCKDIR);
	if(dirp==NULL) 
		fatal("Lock-Directory not found.");
	
	for(dp = readdir(dirp); dp != NULL; dp =readdir(dirp))
		if(!strcmp(LCKTST,dp->d_name+dp->d_namlen-strlen(LCKTST) ))
		{			
			sprintf(lck,"%s%s",LCKDIR,dp->d_name);
			lckfeil=open(lck,O_RDONLY,NULL);
			if(lckfeil==-1) break;
			read(lckfeil,&pid,sizeof(int));
			close(lckfeil);
			if(kill(pid,0)==0 && pid!=getpid())
			{
				closedir(dirp);
				return pid;
			}
		}
	closedir(dirp);	
	return 0;
}


void open_line(char *device)
{
	int		lckfeil,pid;
	struct 	sgttyb	tdis;
	char	lockfeil[MAXPATHLEN];
	
	pid=tst_lock();
	if(pid)	while(kill(pid,0)==0) sleep(1);
	
	modem=open(device,O_RDWR);
	if(modem==-1)	fatal("in open_line failed to open device %s",device);

	if( ioctl(modem,TIOCGETP,&tdis) == -1 ) log("Can't execute ioctl TIOCGETP");
	tdis.sg_ispeed=SPD;
	tdis.sg_ospeed=SPD;
	tdis.sg_flags=RAW|TANDEM;
	if( ioctl(modem,TIOCSETP,&tdis) == -1 ) log("Can't execute ioctl TIOCSETP");
	if( ioctl(modem,TIOCEXCL,NULL) == -1 ) log("Can't execute ioctl TIOCNXCL");

	if( ioctl(modem,TIOCCDTR,NULL) == -1 ) log("Can't execute ioctl TIOCSDTR");
	say("YYY");wait_for("XXX",500);	// clear queue
	if( ioctl(modem,TIOCSDTR,NULL) == -1 ) log("Can't execute ioctl TIOCSDTR");

	dup2(modem,STD_OUT);
	dup2(modem,STD_ERR);

	sprintf(lockfeil,"%s%s",LOCKFILE,device+5);
	lckfeil=open(lockfeil,O_WRONLY | O_CREAT);
	pid=getpid();
	if(lckfeil!=-1)
	{
		write(lckfeil,&pid,sizeof(int));
		close(lckfeil);
	}
	else
		fatal("can't lock %s",lockfeil);
}


void unlock_line(char *device)
{	
	char	lockfeil[MAXPATHLEN];

	sprintf(lockfeil,"%s%s",LOCKFILE,device+5);
	if(!tst_lock())
		remove(lockfeil);
#if DEBUG
	else
		log("logfile changed by someone else !");
#endif
}

int close_line(char *device)
{
	int	tty;
	
	unlock_line(device);
	
	tty=open("/dev/tty",O_RDWR);
	ioctl(tty, TIOCNOTTY, 0);

	close(STD_IN);
	close(STD_OUT);
	close(STD_ERR);
	return 1;
}







