/* @(#)src/transports/smtplib.h	1.2 24 Oct 1990 05:25:59 */

/*
 *	Copyright (C) 1987, 1988 by Ronald S. Karr and Landon Curt Noll
 *
 * See the file COPYING, distributed with smail, for restriction
 * and warranty information.
 */

/*
 * smtplib.h:
 *	interface file for routines in smtplib.c.
 */

/* values returned by functions in smtplib.c */
#define SMTP_SUCCEED	0
#define SMTP_FAIL	(-1)
#define SMTP_AGAIN	(-2)

/*
 * the following structure is passed around between SMTP functions and
 * should be initialized as necessary to describe the SMTP connection
 * characteristics.
 *
 * NOTE:  If "in" is set to NULL, then we will be producing batch SMTP.
 */
struct smtp {
    FILE *in;				/* input channel from remote server */
    FILE *out;				/* output channel to remote server */
    unsigned short_timeout;		/* timeout period for short commands */
    unsigned long_timeout;		/* normal SMTP read timeout period */
    char *nl;				/* line terminator string */
    struct transport *tp;		/* associated transport */
};

/* functions defined in smtplib.c */
extern int smtp_startup();
extern int smtp_send();
extern void smtp_shutdown();
