/*
 * @(#)uumisc.c 1.8 88/06/09	Copyright 1987 Free Software Foundation, Inc.
 *
 * Copying and use of this program are controlled by the terms of the
 * GNU Emacs General Public License.
 *
 * uumisc.c
 *
 * Miscellaneous uucp variables and routines which are used by several
 * uucp main programs.
 */
#include "includes.h"		/* System include files, system dependent */
#include "uucp.h"		/* Uucp definitions and parameters */
#include "sysdep.h"		/* System dependent parts of gnuucp */

char	Myname[MAX_HOST];	/* Our uucp hostname, set from usenet.ctl */
char	host_name[MAX_HOST] = "gnuucp";	/* Other guy's host name */
char	*Control;		/* Control file name */
char	*Spool;			/* Spool directory root name */
char	*Sysfile;		/* L.sys file */
char	*Userfile;		/* USERFILE */
char	*Pubdir;		/* Public Directory */
char	*Logfile;		/* Logging file */
char	who[NAMESIZE] = "-";	/* Who sent us a file */
int	debug = -1;		/* -1 indicates ctl file should set it */
int	ourpid = 0;		/* Our process ID */
int	logfd;			/* file desc of uucp logfile */

struct port *ports, *porttail;	/* Chain of serial port definitions */

char	*gimmestring();		/* Forward declaration */

/*
 * Read the control file and grab a few parameters.
 */
read_params(ctl)
	char *ctl;
{
	FILE	*fd;
	char	buf[MAX_CTLLINE];
	register struct port *newport;
	register char *cmd;
	register char	*p;

	if (ctl) {
		/* Remove any possible setuid if user spec'd a control file */
		/* FIXME: this is system dependent....sigh */
#ifndef MSDOS
		setuid(getuid());
#endif
	} else {
		/* Use the system default control file */
		ctl = sysdep_control;
	}
	Control = ctl;
	if (! (fd = fopen(ctl, "r"))) {
		printf("Can't find configuration file %s\n", ctl);
		return FAIL;
	}

	/* find path to inbound news */
	while (NULL != fgets(buf, sizeof buf, fd)) {

		cmd = strtok(buf, CTL_DELIM);
		if (!cmd) continue;		/* Skip blank lines */
		for (p = cmd; *p; p++)
			if (isupper(*p)) *p = tolower(*p);

		/* Now figure out which one it is */

		       if (strcmp(cmd, "spool") == 0) {
			Spool = gimmestring();
		} else if (strcmp(cmd, "sysfile") == 0) {
			Sysfile = gimmestring();
		} else if (strcmp(cmd, "userfile") == 0) {
			Userfile = gimmestring();
		} else if (strcmp(cmd, "pubdir") == 0) {
			Pubdir = gimmestring();
		} else if (strcmp(cmd, "logfile") == 0) {
			Logfile = gimmestring();
		} else if (strcmp(cmd, "nodename") == 0) {
			strcpy(Myname, strtok((char *)NULL, CTL_DELIM) ) ;
		} else if (strcmp(cmd, "debug") == 0) {
			if (debug < 0) {
				debug = atoi(strtok((char *)NULL, CTL_DELIM));
			}
		} else if (strcmp(cmd, "port") == 0) {
			newport = (struct port *)malloc(sizeof *newport);
			p = strtok((char *)NULL, CTL_DELIM);
			strcpy(newport->portname, p);
			p = strtok((char *)NULL, CTL_DELIM);
			strcpy(newport->modemname, p);
			p = strtok((char *)NULL, CTL_DELIM);
			strcpy(newport->devname, p);
			p = strtok((char *)NULL, CTL_DELIM);
			newport->baud = atol(p);
			/* Add it to the end of the chain */
			newport->chain = (struct port *)0;
			if (ports)
				porttail->chain = newport;
			else
				ports = newport;
			porttail = newport;
		}
	}

	fclose(fd);
	return SUCCESS;
}

/* Scan out next arg as a string, return it or NULL if none there. */
char *
gimmestring()
{
	register char *p, *q;

	p = strtok((char *)NULL, CTL_DELIM);
	if (p == NULL)
		return p;
	q = (char *)malloc(strlen(p)+1);
	strcpy(q, p);
	return q;
}

/*
 * Scan out an "argv" from a blank-separated string.
 *
 * Result is argc, or -1 if there are too many args.
 */
int
getargs(string, argv, maxargc)
	char	*string;
	char	**argv;
	int	maxargc;
{
	int	argc = 0;

	while (*string == ' ') string++;

	for (; *string; ) {
		argv[argc++] = string;		/* Record position */
		if (argc >= maxargc) return -1;
		while (*string && *string != ' ') string++;
		if (*string == '\0') break;
		*string++ = '\0';		/* Null terminate it */
		while (*string == ' ') string++;
	}

	argv[argc] = (char *)0;			/* Null after last one */
	return argc;
}

/*
 * Log file writing subroutine.
 *
 * Makes incredibly ugly log entries that look *just like* Unix uucp's
 * incredibly ugly log entries.
 *
 * Once we don't care about compatability, we should do this much better.
 */
logit(one, two)
	char *one, *two;
{
	char logbuf[(NAMESIZE*4)+SLOP+50];	/* Temp buffer for logs */
	int len;

	if (logfd <= 0) {
		/* Open the log file if not already open */
		if (Logfile == 0 || *Logfile == 0)
			return;		/* If none specified, no logging. */
		logfd = open(Logfile, O_CREAT|O_WRONLY|O_APPEND, 0644);
#if O_CREAT == 0
		if (logfd < 0)
			logfd = creat(Logfile, 0644);
#endif
		if (logfd < 0) {
			if (DEBUG_LEVEL(0)) perror(Logfile);
			exit(39);
		}
#if O_APPEND == 0
		lseek(logfd, 0L, SEEK_END);	/* Seek to eof */
#endif
	}

	sprintf(logbuf, "%s %s (%s) %s (%s)\n",
		who, host_name, time_and_pid(), one, two);

	DEBUG(0, "%s", logbuf);

	len = strlen(logbuf);
	if (len != write(logfd, logbuf, len)) {
		if (DEBUG_LEVEL(0)) {
			fprintf(stderr, "Can't write to log, terminating!\n");
			perror(Logfile);
		}
		exit(39);		/* Terminate if we can't log */
	}

#ifdef LOGCLOSE
	if (close(logfd) != 0) {
		if (DEBUG_LEVEL(0)) {
			fprintf(stderr, "Can't close log, terminating!\n");
			perror(Logfile);
		}
		exit(39);		/* Terminate if we can't log */
	}
	logfd = -1;
#endif
}
