/* $Id: bitmaps.c,v 1.1.1.1 1992/01/10 18:29:52 jtsillas Exp $ */

/*****************************************************************************
 *
 *  Copyright 1989 The University of Texas at Austin
 *  Copyright 1990 Microelectronics and Computer Technology Corporation
 *  Copyright 1990 Thomson Consumer Electronics, Inc.
 *  Copyright 1991 Bull HN Worldwide Info Systems, Inc.
 *
 *****************************************************************************/

/*  bitmaps.c
 *
 *    Contain bitmap data for a 48x48 and a 64x64 mxgdb icon, and the 
 *	stop sign, execution arrow, up-down arrow, and bomb sign used 
 *	in the source window. Also contains the data for all the command
 *      buttons. The widths and height are in bitmaps.h.
 */

/* bitmap data for 48x48 mxgdb icon */

char mxgdb48_bits[] = {
   0xff, 0x0f, 0x00, 0x00, 0x00, 0xf0, 0xfe, 0x1f, 0x00, 0x00, 0x00, 0xf0,
   0xfc, 0x3f, 0x00, 0x00, 0x00, 0x78, 0xfc, 0x3f, 0x00, 0x00, 0x00, 0x3c,
   0xf8, 0x7f, 0x00, 0x02, 0x00, 0x3c, 0xf0, 0xff, 0x00, 0x02, 0x00, 0x1e,
   0xe0, 0xff, 0x01, 0x04, 0x00, 0x0f, 0xe0, 0xff, 0x01, 0x04, 0x80, 0x07,
   0xc0, 0xff, 0xe3, 0xff, 0xc0, 0x03, 0x80, 0xff, 0x1f, 0x01, 0xc7, 0x03,
   0x00, 0xff, 0x27, 0x01, 0xf8, 0x01, 0x00, 0xff, 0xcf, 0x60, 0xf0, 0x10,
   0x00, 0xfe, 0x1f, 0x90, 0xf8, 0x10, 0x00, 0xfc, 0x3f, 0x90, 0xbc, 0x08,
   0x00, 0xfc, 0x7f, 0x60, 0x3c, 0x07, 0x00, 0xfe, 0xff, 0x03, 0x1e, 0x02,
   0x00, 0xfe, 0xff, 0x04, 0x0f, 0x02, 0x00, 0xff, 0xff, 0x85, 0x07, 0x04,
   0x80, 0xff, 0xff, 0xc3, 0xc3, 0x04, 0x80, 0xdf, 0xff, 0xe7, 0x23, 0x05,
   0x84, 0x9f, 0xff, 0xef, 0x25, 0x09, 0xc8, 0x19, 0xff, 0xf7, 0xc4, 0x08,
   0xf0, 0x18, 0xfe, 0x7b, 0x03, 0x08, 0xc0, 0x1f, 0xfc, 0x3d, 0x00, 0x08,
   0xc0, 0xff, 0xff, 0xff, 0xff, 0x0f, 0xc0, 0x1f, 0x78, 0x7f, 0x00, 0x08,
   0xf0, 0x98, 0xbd, 0xff, 0x00, 0x08, 0xc8, 0x59, 0xde, 0xff, 0x61, 0x08,
   0x84, 0x5f, 0xef, 0xff, 0x91, 0x04, 0x80, 0x9f, 0xc7, 0xff, 0x93, 0x04,
   0x80, 0x9f, 0x87, 0xff, 0x67, 0x04, 0x00, 0xdf, 0x03, 0xff, 0x0f, 0x02,
   0x00, 0xfe, 0x19, 0xfe, 0x1f, 0x02, 0x00, 0xfe, 0x24, 0xfe, 0x1f, 0x07,
   0x00, 0x7c, 0x24, 0xfc, 0xff, 0x08, 0x00, 0x78, 0x18, 0xfa, 0x7f, 0x10,
   0x00, 0x3c, 0x00, 0xf2, 0xff, 0x10, 0x00, 0xde, 0x00, 0xfc, 0xff, 0x00,
   0x00, 0x8f, 0x0f, 0xe0, 0xff, 0x01, 0x80, 0x87, 0xf0, 0xff, 0xff, 0x03,
   0x80, 0x87, 0x00, 0x84, 0xff, 0x07, 0xc0, 0x43, 0x00, 0x84, 0xff, 0x07,
   0xe0, 0x21, 0x00, 0x02, 0xff, 0x0f, 0xf0, 0x00, 0x00, 0x02, 0xfe, 0x1f,
   0x78, 0x00, 0x00, 0x00, 0xfc, 0x3f, 0x78, 0x00, 0x00, 0x00, 0xfc, 0x3f,
   0x3c, 0x00, 0x00, 0x00, 0xf8, 0x7f, 0x1e, 0x00, 0x00, 0x00, 0xf0, 0xff};


/* bitmap data for 64x64 mxgdb icon */

char mxgdb64_bits[] = {
   0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xfe, 0xff, 0x01, 0x00,
   0x00, 0x00, 0x00, 0xf8, 0xfc, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x7c,
   0xf8, 0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf8, 0xff, 0x07, 0x00,
   0x00, 0x00, 0x00, 0x1f, 0xf0, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x80, 0x0f,
   0xe0, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x80, 0x0f, 0xc0, 0xff, 0x3f, 0x00,
   0x00, 0x00, 0xc0, 0x07, 0xc0, 0xff, 0x3f, 0x00, 0x01, 0x00, 0xe0, 0x03,
   0x80, 0xff, 0x7f, 0x00, 0x02, 0x00, 0xf0, 0x01, 0x00, 0xff, 0xff, 0x00,
   0x04, 0x00, 0xf8, 0x00, 0x00, 0xfe, 0xff, 0x01, 0x04, 0x00, 0xf8, 0x00,
   0x00, 0xfe, 0xff, 0x01, 0x04, 0x00, 0x7c, 0x00, 0x00, 0xfc, 0xff, 0xff,
   0xff, 0x01, 0x3e, 0x04, 0x00, 0xf8, 0xff, 0x07, 0x00, 0x1e, 0x1f, 0x04,
   0x00, 0xf0, 0xff, 0x0f, 0x00, 0xe0, 0x0f, 0x04, 0x00, 0xf0, 0xff, 0x0f,
   0x80, 0x81, 0x07, 0x02, 0x00, 0xe0, 0xff, 0x1f, 0x40, 0xc2, 0x07, 0x01,
   0x00, 0xc0, 0xff, 0xbf, 0x41, 0xe2, 0x8b, 0x01, 0x00, 0xc0, 0xff, 0x7f,
   0x82, 0xf1, 0xd1, 0x00, 0x00, 0xe0, 0xff, 0xff, 0x02, 0xf8, 0x60, 0x00,
   0x00, 0xf0, 0xff, 0xff, 0x01, 0x7c, 0x40, 0x00, 0x00, 0xf8, 0xfe, 0xff,
   0x01, 0x7c, 0x80, 0x00, 0x00, 0xfc, 0xfc, 0xff, 0x03, 0x3e, 0x80, 0x00,
   0x00, 0xfc, 0xfc, 0xff, 0x03, 0x1f, 0x00, 0x01, 0x00, 0xfe, 0xf8, 0xff,
   0x87, 0x0f, 0x03, 0x01, 0x00, 0xff, 0xf0, 0xff, 0xcf, 0x87, 0x04, 0x02,
   0x08, 0xff, 0xe0, 0xff, 0xcf, 0x87, 0x04, 0x02, 0x10, 0xe7, 0xe0, 0xff,
   0xe7, 0x03, 0x03, 0x02, 0xe0, 0xe3, 0xc0, 0xff, 0xf3, 0x01, 0x00, 0x04,
   0x80, 0xff, 0x80, 0xff, 0xf9, 0x00, 0x00, 0x04, 0x80, 0xff, 0x00, 0xff,
   0xfc, 0x00, 0x00, 0x04, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x07,
   0x80, 0xff, 0x00, 0x7e, 0xfe, 0x01, 0x00, 0x04, 0x80, 0xff, 0x00, 0x3e,
   0xff, 0x1b, 0x00, 0x04, 0xe0, 0xe3, 0x00, 0x9f, 0xff, 0x27, 0x00, 0x04,
   0x10, 0xe7, 0xb0, 0xcf, 0xff, 0x2f, 0x30, 0x02, 0x08, 0xff, 0xc8, 0xe7,
   0xff, 0x1f, 0x48, 0x02, 0x00, 0xff, 0xe8, 0xe7, 0xff, 0x1f, 0x48, 0x02,
   0x00, 0xfe, 0xf0, 0xc3, 0xff, 0x3f, 0x30, 0x01, 0x00, 0xfc, 0xf0, 0xc1,
   0xff, 0x3f, 0x00, 0x01, 0x00, 0xfc, 0xf8, 0x80, 0xff, 0x7f, 0x80, 0x00,
   0x00, 0xf8, 0x7c, 0x00, 0xff, 0xff, 0x80, 0x00, 0x00, 0xf0, 0x7c, 0x18,
   0xfe, 0xff, 0xc1, 0x00, 0x00, 0xe0, 0x3e, 0x24, 0xfe, 0xff, 0x61, 0x00,
   0x00, 0xc0, 0x1f, 0x24, 0xfc, 0xff, 0xd3, 0x00, 0x00, 0x80, 0x0f, 0x18,
   0xf8, 0xff, 0x8f, 0x01, 0x00, 0xc0, 0x07, 0x00, 0xf4, 0xff, 0x0f, 0x01,
   0x00, 0xe0, 0x0f, 0x00, 0xe4, 0xff, 0x1f, 0x02, 0x00, 0xf0, 0x39, 0x00,
   0xf8, 0xff, 0x1f, 0x04, 0x00, 0xf0, 0xc9, 0x03, 0xc0, 0xff, 0x3f, 0x04,
   0x00, 0xf8, 0x08, 0xfc, 0xff, 0xff, 0x7f, 0x04, 0x00, 0x7c, 0x04, 0x00,
   0x01, 0xff, 0x7f, 0x00, 0x00, 0x3e, 0x02, 0x00, 0x01, 0xff, 0xff, 0x00,
   0x00, 0x3e, 0x00, 0x00, 0x01, 0xfe, 0xff, 0x01, 0x00, 0x1f, 0x00, 0x80,
   0x00, 0xfc, 0xff, 0x03, 0x80, 0x0f, 0x00, 0x00, 0x00, 0xf8, 0xff, 0x03,
   0xc0, 0x07, 0x00, 0x00, 0x00, 0xf8, 0xff, 0x07, 0xe0, 0x03, 0x00, 0x00,
   0x00, 0xf0, 0xff, 0x0f, 0xe0, 0x03, 0x00, 0x00, 0x00, 0xe0, 0xff, 0x1f,
   0xf0, 0x01, 0x00, 0x00, 0x00, 0xc0, 0xff, 0x1f, 0xf8, 0x00, 0x00, 0x00,
   0x00, 0xc0, 0xff, 0x3f, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0x7f,
   0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff};


/* bitmap data for stop sign */

char stop_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0xa0, 0x03, 0xb8, 0x0e,
   0xa8, 0x0a, 0xa8, 0x0a, 0xa8, 0x0a, 0x18, 0x08, 0x10, 0x08, 0x30, 0x0c,
   0xe0, 0x07, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00};

/* bitmap data for arrow sign */

char arrow_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x01, 0x80, 0x03,
   0xff, 0x07, 0xff, 0x0f, 0xff, 0x0f, 0xff, 0x07, 0x80, 0x03, 0x80, 0x01,
   0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};


/* bitmap data for up-down (outlined arrow) sign */

char updown_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x01, 0x80, 0x03,
   0xff, 0x06, 0x01, 0x0c, 0x01, 0x0c, 0xff, 0x06, 0x80, 0x03, 0x80, 0x01,
   0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};


/* bitmap data for bomb sign */

char bomb_bits[] = {
   0x00, 0x00, 0x69, 0x00, 0x94, 0x00, 0x8a, 0x00, 0xc0, 0x01, 0xc5, 0x01,
   0xf0, 0x07, 0xf0, 0x07, 0xf8, 0x0f, 0xf8, 0x0d, 0xf8, 0x0d, 0xf8, 0x0d,
   0xf0, 0x06, 0xf0, 0x07, 0xc0, 0x01, 0x00, 0x00};

/* bitmap data for the command buttons */

char pageR_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x00, 0xc0, 0x07, 0x00,
   0x40, 0x0f, 0x00, 0x40, 0x1e, 0x00, 0x40, 0x3c, 0x00, 0x40, 0x78, 0x00,
   0x40, 0xf0, 0x00, 0x40, 0xe0, 0x01, 0x40, 0xc0, 0x03, 0x40, 0x80, 0x07,
   0x40, 0x80, 0x07, 0x40, 0xc0, 0x03, 0x40, 0xe0, 0x01, 0x40, 0xf0, 0x00,
   0x40, 0x78, 0x00, 0x40, 0x3c, 0x00, 0x40, 0x1e, 0x00, 0x40, 0x0f, 0x00,
   0xc0, 0x07, 0x00, 0xc0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

char pageL_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x00, 0xe0, 0x03,
   0x00, 0xf0, 0x02, 0x00, 0x78, 0x02, 0x00, 0x3c, 0x02, 0x00, 0x1e, 0x02,
   0x00, 0x0f, 0x02, 0x80, 0x07, 0x02, 0xc0, 0x03, 0x02, 0xe0, 0x01, 0x02,
   0xe0, 0x01, 0x02, 0xc0, 0x03, 0x02, 0x80, 0x07, 0x02, 0x00, 0x0f, 0x02,
   0x00, 0x1e, 0x02, 0x00, 0x3c, 0x02, 0x00, 0x78, 0x02, 0x00, 0xf0, 0x02,
   0x00, 0xe0, 0x03, 0x00, 0xc0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

char step_bits[] = {
   0x00, 0xc0, 0x00, 0x00, 0xe0, 0x01, 0x00, 0xf0, 0x03, 0x00, 0xf0, 0x07,
   0x00, 0xf8, 0x0f, 0x00, 0xf8, 0x0f, 0x00, 0xf8, 0x1f, 0x00, 0xf8, 0x1f,
   0x00, 0xf8, 0x1f, 0x00, 0xf8, 0x1f, 0x00, 0xf0, 0x1f, 0x00, 0xf0, 0x1f,
   0x00, 0xe0, 0x1f, 0x00, 0x80, 0x1f, 0x00, 0x00, 0x1f, 0x18, 0x00, 0x0f,
   0x3c, 0x00, 0x0e, 0x3e, 0x00, 0x00, 0x7f, 0x80, 0x0f, 0x7f, 0x80, 0x0f,
   0x7f, 0x80, 0x0f, 0xff, 0x00, 0x07, 0xff, 0x00, 0x00, 0xff, 0x00, 0x00};

char next_bits[] = {
   0x00, 0xc0, 0x00, 0x00, 0x20, 0x01, 0x00, 0x30, 0x03, 0x00, 0x10, 0x06,
   0x00, 0x18, 0x08, 0x00, 0x08, 0x08, 0x00, 0x08, 0x18, 0x00, 0x08, 0x10,
   0x00, 0x08, 0x10, 0x00, 0x08, 0x10, 0x00, 0x10, 0x10, 0x00, 0x10, 0x10,
   0x00, 0x60, 0x10, 0x00, 0x80, 0x19, 0x00, 0x00, 0x19, 0x18, 0x00, 0x0b,
   0x24, 0x00, 0x0e, 0x22, 0x00, 0x00, 0x41, 0x80, 0x0f, 0x41, 0x80, 0x08,
   0x40, 0x80, 0x08, 0x80, 0x00, 0x07, 0x80, 0x00, 0x00, 0x80, 0x00, 0x00};

char print_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x60,
   0x1c, 0x07, 0x70, 0xb8, 0x83, 0x60, 0xf0, 0x01, 0x61, 0xe0, 0x00, 0x62,
   0xe0, 0xf8, 0x67, 0xf0, 0x01, 0x62, 0xb8, 0x03, 0x61, 0x1c, 0x87, 0x60,
   0x0e, 0x0e, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xde, 0x93, 0x74, 0x52, 0x92, 0x25, 0xd2, 0x93, 0x26, 0xde, 0x91, 0x24,
   0x42, 0x92, 0x24, 0x42, 0x92, 0x24, 0x42, 0x92, 0x24, 0x00, 0x00, 0x00};

char down_bits[] = {
   0x00, 0x00, 0xe0, 0x03, 0x20, 0x02, 0x20, 0x02, 0x20, 0x02, 0x20, 0x02,
   0x20, 0x02, 0x20, 0x02, 0x20, 0x02, 0x20, 0x02, 0x3c, 0x1e, 0x08, 0x08,
   0x10, 0x04, 0x20, 0x02, 0x40, 0x01, 0x80, 0x00};

char up_bits[] = {
   0x80, 0x00, 0x40, 0x01, 0x20, 0x02, 0x10, 0x04, 0x08, 0x08, 0x3c, 0x1e,
   0x20, 0x02, 0x20, 0x02, 0x20, 0x02, 0x20, 0x02, 0x20, 0x02, 0x20, 0x02,
   0x20, 0x02, 0x20, 0x02, 0x20, 0x02, 0xe0, 0x03};

char stack_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0xfc, 0x7f, 0x00, 0x04, 0x00, 0xee, 0x04, 0x00,
   0xa2, 0xfc, 0x7f, 0xee, 0x04, 0x00, 0x28, 0x04, 0x00, 0x2e, 0xfc, 0x7f,
   0x00, 0x04, 0x00, 0x04, 0x04, 0x00, 0x44, 0xfc, 0x7f, 0x84, 0x54, 0x55,
   0xfc, 0xad, 0x2a, 0x80, 0x54, 0x55, 0x40, 0xfc, 0x7f, 0x00, 0x04, 0x00,
   0x00, 0x04, 0x00, 0x00, 0x04, 0x00, 0x00, 0x04, 0x02, 0x00, 0x04, 0x00,
   0x00, 0x04, 0x02, 0x00, 0x04, 0x00, 0x00, 0x04, 0x02, 0x00, 0x00, 0x00};

char cont_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x27, 0xfa, 0xa2, 0x68, 0x22,
   0x82, 0xa8, 0x22, 0x82, 0x28, 0x23, 0x82, 0x28, 0x22, 0x82, 0x28, 0x22,
   0xa2, 0x28, 0x22, 0x1c, 0x27, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x7c, 0x00, 0x0c, 0xaa, 0xf8, 0x17,
   0xaa, 0x00, 0x20, 0x02, 0x01, 0x40, 0x02, 0x01, 0xc0, 0x82, 0xf8, 0x67,
   0xc6, 0xf0, 0x37, 0x7c, 0x00, 0x1c, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00};

char finish_bits[] = {
   0x00, 0x00, 0x00, 0x08, 0x4f, 0x22, 0x04, 0x41, 0x26, 0x04, 0x47, 0x2a,
   0x04, 0x41, 0x32, 0x02, 0x41, 0x22, 0x04, 0x41, 0x22, 0x04, 0x00, 0x00,
   0x04, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x88, 0x00, 0x00, 0x88, 0x01,
   0x00, 0x88, 0x01, 0x00, 0x88, 0x01, 0x08, 0x88, 0x01, 0x10, 0x88, 0x01,
   0x10, 0x88, 0x01, 0x10, 0x8f, 0x07, 0x20, 0x02, 0x06, 0x10, 0x04, 0x03,
   0x10, 0x88, 0x01, 0x10, 0xd0, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00};

char run_bits[] = {
   0x00, 0x00, 0x00, 0x7c, 0x42, 0x21, 0x84, 0x42, 0x23, 0x84, 0x42, 0x25,
   0x7c, 0x42, 0x29, 0x24, 0x42, 0x31, 0x44, 0x42, 0x21, 0x84, 0x42, 0x21,
   0x84, 0x3c, 0x21, 0x00, 0x00, 0x00, 0xfc, 0xff, 0x3f, 0x80, 0x80, 0x01,
   0x80, 0x80, 0x01, 0x80, 0x80, 0x01, 0x80, 0x80, 0x01, 0x80, 0x80, 0x01,
   0xf0, 0x80, 0x0f, 0x20, 0x00, 0x06, 0x40, 0x00, 0x03, 0x80, 0x80, 0x01,
   0x00, 0xc1, 0x00, 0x00, 0x62, 0x00, 0x00, 0x34, 0x00, 0x00, 0x18, 0x00};

char disp_bits[] = {
   0x00, 0x00, 0x00, 0xc0, 0x01, 0x00, 0x30, 0x06, 0x00, 0x08, 0x08, 0x00,
   0x04, 0x10, 0x20, 0x24, 0x12, 0x30, 0x62, 0x23, 0x21, 0xc2, 0x21, 0x22,
   0xc2, 0xa1, 0x27, 0x62, 0x23, 0x22, 0x24, 0x22, 0x21, 0x04, 0x10, 0x70,
   0x08, 0x08, 0x00, 0x30, 0x06, 0x00, 0xc0, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x38, 0xe2, 0x1c, 0x48, 0x12, 0x24, 0x48, 0x12, 0x24, 0x48, 0xf2, 0x1c,
   0x48, 0x82, 0x04, 0x48, 0x82, 0x04, 0x38, 0x72, 0x04, 0x00, 0x00, 0x00};

char undisp_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0x00, 0x00, 0x01, 0x01,
   0x00, 0x00, 0x00, 0x40, 0x00, 0x04, 0x00, 0x00, 0x00, 0x20, 0x00, 0x08,
   0x00, 0x00, 0x00, 0x20, 0x00, 0x08, 0x00, 0x00, 0x00, 0x20, 0x00, 0x08,
   0x00, 0x00, 0x00, 0x40, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01,
   0x00, 0x54, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x4d, 0x77, 0x6a, 0x55, 0x51,
   0xaa, 0x55, 0x77, 0x2a, 0x55, 0x14, 0x2e, 0x4d, 0x17, 0x00, 0x00, 0x00};

char clear_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0xc0, 0xff, 0x01, 0xe0, 0x80, 0x03,
   0x30, 0x00, 0x06, 0x18, 0x00, 0x0e, 0x0c, 0x0e, 0x1b, 0x0c, 0xba, 0x19,
   0x86, 0xeb, 0x30, 0x86, 0xea, 0x30, 0x86, 0xba, 0x30, 0x86, 0xba, 0x30,
   0x86, 0x8d, 0x30, 0x06, 0x87, 0x30, 0x06, 0xc3, 0x30, 0x8c, 0x7f, 0x18,
   0xcc, 0x7e, 0x18, 0x78, 0x00, 0x0c, 0x30, 0x00, 0x06, 0xe0, 0x80, 0x03,
   0xc0, 0xff, 0x01, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

char prints_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xc0, 0x30, 0x20, 0xd4, 0x39, 0x30, 0x88, 0x1f, 0x21, 0x3e, 0x0f, 0x22,
   0x08, 0xcf, 0x27, 0x94, 0x1f, 0x22, 0xc0, 0x39, 0x21, 0xc0, 0x30, 0x70,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0xee, 0x4a, 0x57, 0xaa, 0x5a, 0x22, 0xee, 0x6a, 0xfa,
   0x62, 0x4a, 0x22, 0xa2, 0x4a, 0x52, 0xa2, 0x4a, 0x02, 0x00, 0x00, 0x00};

char args_bits[] = {
   0x00, 0x00, 0x00, 0x88, 0xc7, 0x71, 0x94, 0x28, 0x0a, 0xa2, 0x28, 0x08,
   0xa2, 0x27, 0x78, 0xbe, 0xa2, 0x43, 0xa2, 0x24, 0x42, 0xa2, 0x28, 0x42,
   0xa2, 0xc8, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0x04, 0x10, 0xcc, 0x02, 0x20,
   0x78, 0x02, 0x20, 0x30, 0x02, 0x20, 0x78, 0x02, 0x20, 0xcc, 0xa2, 0x22,
   0x84, 0x04, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

char locals_bits[] = {
   0x00, 0x00, 0x00, 0x30, 0x00, 0x18, 0x08, 0x00, 0x20, 0x08, 0x00, 0x20,
   0x08, 0x00, 0x20, 0x10, 0x00, 0x10, 0x10, 0x00, 0x10, 0x08, 0x00, 0x20,
   0x10, 0x00, 0x10, 0x90, 0x99, 0x11, 0x88, 0x99, 0x21, 0x08, 0x00, 0x20,
   0x08, 0x00, 0x20, 0x30, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x84, 0x31, 0x13, 0x44, 0x8a, 0x14, 0x44, 0x8a, 0x14,
   0x44, 0x8a, 0x17, 0x44, 0x8a, 0x14, 0x9c, 0xb1, 0x74, 0x00, 0x00, 0x00};

/* Bitmaps for the search up and down arrows */

char arrowup_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x3c, 0x00,
   0x00, 0x7e, 0x00, 0x00, 0xff, 0x00, 0x80, 0xff, 0x01, 0xc0, 0xff, 0x03,
   0xe0, 0xff, 0x07, 0xf0, 0xff, 0x0f, 0xf8, 0xff, 0x1f, 0xfc, 0xff, 0x3f,
   0xfe, 0xff, 0x7f, 0xfe, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

char arrowdown_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0x7f, 0xfe, 0xff, 0x7f,
   0xfc, 0xff, 0x3f, 0xf8, 0xff, 0x1f, 0xf0, 0xff, 0x0f, 0xe0, 0xff, 0x07,
   0xc0, 0xff, 0x03, 0x80, 0xff, 0x01, 0x00, 0xff, 0x00, 0x00, 0x7e, 0x00,
   0x00, 0x3c, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

