static char rcsid[] = "$Id: utils.c,v 1.1.1.1 1992/01/10 18:31:13 jtsillas Exp $";

/*****************************************************************************
 *
 *  Copyright 1989 The University of Texas at Austin
 *  Copyright 1990 Microelectronics and Computer Technology Corporation
 *  Copyright 1990 Thomson Consumer Electronics, Inc.
 *  Copyright 1991 Bull HN Worldwide Info Systems, Inc.
 *
 *****************************************************************************/

/*  utils.c
 *
 *    Contain common routines used by other functions.
 *
 *    TextPositionToLine(): 	Return text position give a line number.
 *    LineToStopNo():		Return the stop number given a line number.
 *    DisableWindowResize():	Fix the size of a window inside vpane.
 *    bell():			Ring the bell.
 *    concat():			Concatenate two strings together
 */

#include "global.h"
#include <Xm/Text.h>

/*
 * Get the line number where the caret is.
 */
int TextPositionToLine(pos)
XmTextPosition pos;
{
    int line;

    if (displayedFile) {
	if (pos >= displayedFile->linepos[displayedFile->topline]) {
	    for (line = displayedFile->topline;
		 pos > displayedFile->linepos[line]; line++);
	    return (pos == displayedFile->linepos[line] ? line : line-1);
	}
	else {
	    for (line = 1; pos > displayedFile->linepos[line]; line++);
	    return (pos == displayedFile->linepos[line] ? line : line-1);
	}
    }
    else
        return 0;
}

/*
 *  Return the stop number associated with a given line number.
 *  Return 0 if stop number not found.
 */
int LineToStop_no(line)
int line;
{
    int i;

    for (i=1; i <= nstops; i++)
        if (stops[i].line == line && stops[i].file && displayedFile &&
            !strcmp(stops[i].file, displayedFile->pathname)) {
            return i;
        }
    return 0;
}

void bell(volume)
int volume;
{
    XBell(XtDisplay(toplevel), volume);
}

/* append string s2 to end of string s1 and return the result */

char *concat(s1, s2)
char *s1, *s2;
{
    if (s2) {
        if (s1 == NULL) {
            s1 = XtMalloc((strlen(s2)+1)*sizeof(char));
            strcpy(s1, s2);
        }
        else {
            s1 = XtRealloc(s1, strlen(s1)+strlen(s2)+2);
            strcat(s1, s2);
        }
    }
    return (s1);
}

#if !defined(SYSV) 

char *strstr(bigstring, littlestring)
const char *bigstring, *littlestring;
{
  register char *bigptr = bigstring;
  register char *littleptr = littlestring;
  register char *theptr;

  theptr = bigptr;
  while(*bigptr)
    {
      if (*bigptr == *littleptr)
	{
	  littleptr++;
	  bigptr++;
	  if(!(*littleptr)) return (theptr);
	}
      else 
	{
	  bigptr++;
	  littleptr = littlestring;
	  theptr = bigptr;
	}
    }
  return (0);
}

#endif



