
#include "Application.h"
#include "OpenPanel.h"
#include "ObjCCallback.h"

@implementation OpenPanel
- init:(const char*)name parent:(Widget)p
{
  [super init:name];
  _w = XmCreateFileSelectionDialog(p,name,NULL,0);
  target = nil;

  return self;
}

- makeKeyAndOrderFront:s
{
  return [XApp makeKeyAndOrderFront: self];
}

- target:t { target = t; return self; }
- message:(SEL)m 
{ msg = m; return self; }

- target 
{ return target; }

- (SEL)message 
{ return msg; }


- removeHelpButton
{
    XtUnmanageChild(XmFileSelectionBoxGetChild(_w,XmDIALOG_HELP_BUTTON));
    return self;
}


- target:t message:(SEL)m okCallback:(XtPointer)d
{
  ObjCAddCallback(_w,XmNokCallback,d,self,t,m);
  //[[[self target:t] message:m] okCallback:d]; 
  return self;
}
- target:t message:(SEL)m cancelCallback:(XtPointer)d
{
  ObjCAddCallback(_w,XmNcancelCallback,d,self,t,m);
  return self;
}





- (char*)dirSpec
{
  char *d;
  XmString str;

  XtVaGetValues(_w,XmNdirSpec,&str,NULL);
  XmStringGetLtoR(str,XmSTRING_DEFAULT_CHARSET,&d);
  return d;
}

- unmanage
{
  XtUnmanageChild(_w);
  return self;
}

- defaultOpenCallback
{
  ObjCAddCallback(_w,XmNokCallback,NULL,self,self,@selector(openOkCallback:));
  return self;
}
- openOkCallback:co
{
  [self unmanage];
  return self;
}


- defaultCancelCallback
{
  ObjCAddCallback(_w,XmNcancelCallback,NULL,self,self,@selector(openCancelCallback:));
  return self;
}
- openCancelCallback:co
{
  [self unmanage];
  return self;
}


- okCallback:(XtPointer)d
{
  ObjCAddCallback(_w,XmNokCallback,d,self,target,msg);
  return self;
}

- cancelCallback:(XtPointer)d
{
  ObjCAddCallback(_w,XmNcancelCallback,d,self,target,msg);
  return self; 
}

- helpCallback:(XtPointer)d
{
  return self;
}




@end

