/* Implementation for ActionCell
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, Imran Qureshi, and Libing Wang (SLAC)
 *	    Mike Kienenberger (Alaska)
 *
 * This file is part of an Objective-C library for a window system
 *
 * ActionCell.m,v 1.31 1994/06/11 03:55:06 pfkeb Exp
 */
 

#include "ActionCell.h"

#include "Control.h"


@implementation ActionCell:Cell

- controlView
{
    return controlView;
}

// - setFont:fontObj;
// - setAlignment:(int)mode;
// - setBordered:(BOOL)flag;
// - setBezeled:(BOOL)flag;
// - setEnabled:(BOOL)flag;
// - setFloatingPointFormat:(BOOL)autoRange 
//                     left:(unsigned int)leftDigits 
//                    right:(unsigned int)rightDigits;
// - setIcon:(const char *)iconName;

- target
{
    return target;
}

- setTarget:anObject
{
    target = anObject;
    return self;
}

- (SEL) action
{
    return action;
}

- setAction:(SEL)aSelector
{
    action = aSelector;
    return self;
}

- (int) tag
{
    return tag;
}

- setTag:(int)anInt
{
    tag = anInt;
    return self;
}

// - (const char *)stringValue;
// - (int)intValue;
// - (float)floatValue;
// - (double)doubleValue;
// - setStringValue:(const char *)aString;
// - setStringValueNoCopy:(char *)aString shouldFree:(BOOL)flag;
// - drawSelf:(const NXRect *)cellFrame inView:controlView;
// - write:(NXTypedStream *)stream;


- read:(TypedStream*)typedStream
{
    [super read:typedStream];
    objc_read_type(typedStream, "i", &tag);
//    objc_read_object(typedStream, &target);
//    objc_read_type(typedStream, ":", &action);
    return self;
}

- awake
{
    [super awake];
    
    return self;
}

- copy
{
    ActionCell	*newCell;

    newCell = [super copy];
    [newCell _setFrame:&_frame inView:controlView];
    [newCell setTag:tag];
    [newCell setTarget:target];
    [newCell setAction:action];
    return newCell;
}

- sendAction
{
 /*
  * not a OpenStep method.  
  * Implemented in this library for use by the call-back function 
  */
    if (controlView && [controlView respondsTo:@selector(selectCell:)]) {
	[controlView selectCell:self];
    }
    [controlView sendAction];
    return self;
}

- _setControlView:aView
{
    controlView = aView;
    return self;
}
- _setFrame:(const NXRect *)frame inView:aView
{
    [self _setFrame:frame];
    [self _setControlView:aView];
    return self;
}

@end
