/* Interface for Box class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, Imran Qureshi, and Libing Wang
 *
 * This file is part of an Objective-C class library for a window system
 *
 * Box.h,v 1.18 1994/06/15 18:57:27 pfkeb Exp
 */

 
#ifndef _Box_h_
#define _Box_h_

#include "View.h"

#define NX_NOBORDER	0
#define NX_LINE		1
#define NX_BEZEL	2
#define NX_GROOVE	3
#define NX_RIDGE	4

// Title positions:
#define NX_NOTITLE	0
#define NX_ABOVETOP	1
#define NX_ATTOP	2
#define NX_BELOWTOP	3
#define NX_ABOVEBOTTOM	4
#define NX_ATBOTTOM	5
#define NX_BELOWBOTTOM	6

#define DEF_OFFSET	5

#define BEZEL_THICKNESS 2

/* STRUCTURE OF A BOX CLASS:

       _widgetid
           |
        ---+---------
       |             |
    _boxwid      title cell object (contains a _widgetid of its own) 

   Hope this helps clarify what's going on in this class... slf
*/

@interface Box : View
{
  View     *contentView;
  id       cell;	// the title cell
  char     *title;
  int      border;
  NXSize   offsets;
  int      titlePosition;
  int	   thickness;
  NXRect   borderRect;	// should hold rect for the border... 
  NXRect   titleRect;	// bounding box of the title cell...

  // There is no corresponding member for this in NeXTSTEP:
  View     *borderView;  // holds the bordering code...
}

- (int)borderType;
- setBorderType:(int)borderType;
- initFrame:(const NXRect *)frameRect;
- cell;
- getOffsets:(NXSize *)theSize;
- setOffsets:(NXCoord)width :(NXCoord)height;
- sizeToFit;
- sizeTo:(NXCoord)horizontal :(NXCoord)vertical;
- (int)titlePosition;
- setTitlePosition:(int)pos;
- (char *)title;
- setTitle:(const char *)aString;
- contentView;
- setContentView:aView;
- replaceSubview:oldView with:newView;
- addSubview:aView;
- read:(TypedStream *)ts;
- (void *)_widget;
- _setBorder:(NXRect *)aBorder;

// Not implemented, but declared:

- font;
- setFont:fontobj;
- drawSelf:(const NXRect *)rects :(int)rectCount;
- (int)heightAdjust;
- setFrameFromContentFrame:(const NXRect *)contentFrame;
@end

#endif  /* _Box_h_ */
