/* Implementation of Button class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, Tom Pavel, Imran Qureshi, and Libing Wang
 *	    Mike Kienenberger (Alaska)
 *
 * This file is part of an Objective-C class library for a window system
 *
 * Button.m,v 1.37 1994/06/11 03:55:18 pfkeb Exp
 */

#include "Button.h"

/* Required for implementation: */
#include "ActionCell.h"
#include "ButtonCell.h"
#include <stdlib.h>		/* for free() */
#include "stdmacros.h"

#include "PopUpList.h"		/* since Button and PopUpList are partners */

@implementation Button:Control


- init
{
    NXRect  rect = {{0, 0}, {50, 50}};

    [self initFrame:&rect];
    return self;
}

- initFrame:(const NXRect *)frameRect
{
    if (!cell) {
	cell = [[ButtonCell alloc] init];
	[self setTitle:"Button"];
    }
    [super initFrame:frameRect];
    instancename = "Button";
    return self;
}

// - initFrame:(const NXRect *)frameRect title:(const char *)aString 
//         tag:(int)anInt target:anObject action:(SEL)aSelector 
//         key:(unsigned short)charCode enabled:(BOOL)flag
// - initFrame:(const NXRect *)frameRect icon:(const char *)aString 
//         tag:(int)anInt target:anObject action:(SEL)aSelector 
//         key:(unsigned short)charCode enabled:(BOOL)flag
// - (const char *)title;

- setTitle:(const char*)aString
{
    if ( !popup ) {
	[cell setStringValue:aString];
    }
    return self;
}


// - setTitleNoCopy:(const char *)aString;
// - (const char *)altTitle;
// - setAltTitle:(const char *)aString;

- (const char *)icon
{
    return [cell icon];
}

- setIcon:(const char *)iconName
{
    [cell setIcon:iconName];
    return self;
}


// - (const char *)altIcon;
// - setAltIcon:(const char *)iconName;
// - image;
// - setImage:image;
// - altImage;
// - setAltImage:image;
// - (int)iconPosition;
// - setIconPosition:(int)aPosition;
// - setIcon:(const char *)iconName position:(int)aPosition;
// - setType:(int)aType;

- (int) state
{
    return [cell state];
}

- setState:(int)value
{
    return [cell setState:value];
}


// - (BOOL)isBordered;
// - setBordered:(BOOL)flag;
// - (BOOL)isTransparent;
// - setTransparent:(BOOL)flag;
// - setPeriodicDelay:(float)delay andInterval:(float)interval;
// - getPeriodicDelay:(float *)delay andInterval:(float *)interval;
// - (unsigned short)keyEquivalent;
// - setKeyEquivalent:(unsigned short)charCode;
// - sound;
// - setSound:soundObj;
// - display;
// - highlight:(BOOL)flag;
// - (BOOL)performKeyEquivalent:(NXEvent *)theEvent;

- performClick:sender
{
	[cell sendAction];
	return self;
}

// - (BOOL)acceptsFirstMouse;

+ new
{
    return [[Button alloc] init];
}

+ newFrame:(const NXRect *)frameRect
{
    return [[Button alloc] initFrame:frameRect];
}

// + newFrame:(const NXRect *)frameRect title:(const char *)aString 
//        tag:(int)anInt target:anObject action:(SEL)aSelector 
//        key:(unsigned short)charCode enabled:(BOOL)flag
// + newFrame:(const NXRect *)frameRect icon:(const char *)aString 
//        tag:(int)anInt target:anObject action:(SEL)aSelector 
//        key:(unsigned short)charCode enabled:(BOOL)flag

/* The following methods are not in NeXTSTEP */

- read:(TypedStream *)ts
{
    [super read:ts];
    objc_read_type(ts, "i", &popup);
    return self;
}

- awake
{
  /* The popuplist will instansiate the widget if there is one */
    if (popup) {
        [[cell target] awakeFrame:&frame];
    } else {
	[self initFrame:&frame];
    }
    return self;
}

- _managedBy:parent
{
  /* The popuplist will instansiate the widget if there is one */
    if (popup) {
        [[cell target] _managedBy:parent];
    } else {
	[super _managedBy:parent];
    }
    return self;
}

@end
