/* Interface for Control class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, Tom Pavel, Imran Qureshi, and Libing Wang
 *
 * This file is part of an Objective-C class library for a window system
 *
 * Control.h,v 1.34 1994/06/11 03:55:32 pfkeb Exp
 */

#ifndef _Control_h_
#define _Control_h_

#include "View.h"

@class ActionCell;
@interface Control:View
{
    int	         tag;
    ActionCell	*cell;
}
// + setCellClass:factoryId;

- initFrame:(const NXRect *)frameRect;
- setFrame:(const NXRect *)frameRect;
- moveTo:(NXCoord)x :(NXCoord)y;
- free;

// - sizeToFit;
// - sizeTo:(NXCoord)width :(NXCoord)height;
// - calcSize;

- cell;

// - setCell:aCell;

- selectedCell;
- target;
- setTarget:anObject;
- (SEL)action;
- setAction:(SEL)aSelector;
- (int)tag;
- setTag:(int)anInt;
- (int)selectedTag;

// - ignoreMultiClick:(BOOL)flag;
// - mouseDown:(NXEvent *)theEvent;
// - (int)mouseDownFlags;
// - (int)sendActionOn:(int)mask;
// - (BOOL)isContinuous;
// - setContinuous:(BOOL)flag;

- (BOOL)isEnabled;
- setEnabled:(BOOL)flag;

// - setFloatingPointFormat:(BOOL)autoRange left:(unsigned)leftDigits 
//                                         right:(unsigned)rightDigits;

- (int)alignment;
- setAlignment:(int)mode;

// - font;
// - setFont:fontObj;
// - setStringValueNoCopy:(char *)aString shouldFree:(BOOL)flag;

- setStringValue:(const char *)aString;

// - setStringValueNoCopy:(const char *)aString;

- setIntValue:(int)anInt;
- setFloatValue:(float)aFloat;
- setDoubleValue:(double)aDouble;
- (const char *)stringValue;
- (int)intValue;
- (float)floatValue;
- (double)doubleValue;

// - update;
// - updateCell:aCell;
// - updateCellInside:aCell;
// - drawCellInside:aCell;
// - drawCell:aCell;

- selectCell:aCell;

// - drawSelf:(const NXRect *)rects :(int)rectCount;
// - sendAction:(SEL)theAction to:theTarget;

- takeIntValueFrom:sender;

- takeFloatValueFrom:sender;
- takeDoubleValueFrom:sender;

- takeStringValueFrom:sender;

// - currentEditor;

- abortEditing;

// - validateEditing;
// - resetCursorRects;
// - write:(NXTypedStream *)stream;

- read:(NXTypedStream *)stream;

+ newFrame:(const NXRect *)frameRect;


/* Methods not in NeXTSTEP */

- sendAction;
- setFrame:(const NXRect *)frameRect;
- setIcon:(const char *)iconName;
- _managedBy:parent wid:(void*)widget;
- _destroy;

@end

#endif /* _Control_h_ */
