/* Implementation of IBConnnector classes
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors:Paul Kunz, Imran Qureshi, and Libing Wang
 *
 * This file is part of an Objective-C class library for a window system
 *
 * IBConnectors.h,v 1.4 1994/06/11 03:55:55 pfkeb Exp
 */

/* This are interfaces for Connector Objects
 * These objects make connections when objects are read from .xmib files.
 */


#include <objc/Object.h>
#include <objc/typedstream.h>

@interface IBConnector:Object
{
  id    source;
  id    destination;
  char    *label;
}
- free;
- write:(TypedStream *) stream;
- read:(TypedStream *) stream;

- source;
- destination;
@end

@interface IBControlConnector:IBConnector
{
}
- write:(TypedStream *)stream;
- read:(TypedStream *)stream;
- establishConnection;
@end

@interface IBOutletConnector : IBConnector
- write:(TypedStream *)stream;
- read:(TypedStream *)stream;
- establishConnection;
@end
