/* Interface for NXBundle class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Adam Fedor, Scott Francis and Paul Kunz
 *
 * This file is part of an Objective-C class library a window system
 *
 * NXBundle.h,v 1.9 1993/10/20 00:44:51 pfkeb Exp
 */

#ifndef _NX_Bundle_h_
#define _NX_Bundle_h_

#include <objc/Object.h>

@interface NXBundle : Object
{
    char	*_directory;
    Class	_principalClass;
    BOOL	_codeLoaded;
    BOOL	_reserved1, _reserved2, _reserved3;
    int		_bundleVersion;
}

+ mainBundle;
+ bundleForClass:aClass;
- init;
- initForDirectory:(const char *)directory;
- (const char *)directory;
- classNamed:(const char *)className;
- principalClass;
- free;
- (BOOL)getPath:(char *)path forResource:(const char *)name
	 ofType:(const char *)ext;
- (BOOL)getPath:(char *)path forSection:(const char *)name;

+ (BOOL)getPath:(char *)path forResource:(const char *)name
	 ofType:(const char *)ext inDirectory: (const char *)bundlePath
    withVersion: (int)version;

+ setSystemLanguages:(const char * const *)languages;

@end

#endif	/* _NX_Bundle_h_ */
