/* Interface for PopUpList class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, and Libing Wang (SLAC)
 *          Mike Kienenberger (Alaska)
 *
 * This file is part of an Objective-C class library for a window system
 *
 * PopUpList.h,v 1.24 1994/06/15 18:58:26 pfkeb Exp
 */
 
#ifndef _PopUpList_h_
#define _PopUpList_h_

#include "Menu.h"

@class MenuCell;
@interface PopUpList:Menu
{
    int 	num_menu;	// number of items in menu
    void 	*_parentwidget;
    void 	*_popuplist;	// widget -- an option menu why? use widgetid
    char 	**val_arr;	// array of names of items in list
    int		_menu_type;	// 0 - popup, 1 - pulldown
}

- init;
- initFrame:(const NXRect *)rect;

- setAction:(SEL)aSelector;
- (SEL)action;
- setTarget:anObject;
- target;
- (const char *)selectedItem;
- setSubMenu:(int)numMenu :(char **)value;
- addItem:(const char *)title;
- addItem:(const char *)aString andRealize:(BOOL)flag;
- removeItemAt:(unsigned int)index;
- (int)indexOfItem:(const char *)title;
- insertItem:(const char *)title at:(unsigned int)index;
- read:(TypedStream *)ts;
- awake;
- write:(TypedStream *)ts;
/* Methods not in NeXTSTEP */
- _managedBy:parent;
- (void *)_widget;
- awakeFrame:(const NXRect *)aFrame;

@end

#endif   /* _PopUpList_h_ */
