/* Interface for SavePanel class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Fred Harris, Paul Kunz, Tom Pavel, 
 *	    Imran Qureshi, and Libing Wang
 *
 * This file is part of an Objective-C class library for a window system
 *
 * SavePanel.h,v 1.14 1994/06/14 18:05:18 pfkeb Exp
 */

 
#ifndef _SavePanel_h_
#define _SavePanel_h_

#include "Panel.h"

/* extern int NXCompleteFilename(char *path, int maxPathSize);
 * extern char *NXExpandFilename(char *path); */

@interface SavePanel : Panel
{
    char               *sprompt;
    char               *filename;
    char               *directory;
    const char        **filenames;
    char               *requiredType;
}

- init;

- ok:sender;
- cancel:sender;

- (int)runModalForDirectory:(const char *)path file:(const char *)name;
- (int)runModal;

- (const char *)filename;
- (const char *)directory;
- setDirectory:(const char *)path;
- setPrompt:(const char *)prompt;
- setTitle:(const char *)aTitle;
- (const char *)requiredFileType;
- setRequiredFileType:(const char *)type;


- setAccessoryView:aView;
@end

#endif /* _SavePanel_h_ */
