/* Interface for ScrollView class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Fred Harris, Paul Kunz, Tom Pavel, 
 *	    Imran Qureshi, and Libing Wang
 *
 * This file is part of an Objective-C class library for a window system
 *
 * ScrollView.h,v 1.16 1994/06/15 18:58:32 pfkeb Exp
 */

 
#ifndef _ScrollView_h_
#define _ScrollView_h_

#include "View.h"

@class ClipView, Scroller;

@interface ScrollView : View
{
    Scroller	*vScroller;
    Scroller	*hScroller;
    ClipView	*contentView;
    int		pageContext;
    int		lineAmount;
    int		borderType;
    BOOL	vScrollerRequired;
    BOOL	hScrollerRequired;
}

// + getFrameSize:(NXSize *)fSize forContentSize:(const NXSize *)cSize 
//   horizScroller:(BOOL)hFlag vertScroller:(BOOL)vFlag
//      borderType:(int)aType;

+ getContentSize:(NXSize *)cSize forFrameSize:(const NXSize *)fSize 
                                horizScroller:(BOOL)hFlag 
                                 vertScroller:(BOOL)vFlag 
                                   borderType:(int)aType;

- initFrame:(const NXRect *)frameRect;

// - getDocVisibleRect:(NXRect *)aRect;
// - getContentSize:(NXSize *)contentViewSize;
// - resizeSubviews:(const NXSize *)oldSize;
// - drawSelf:(const NXRect *)rects :(int)rectCount;

- setDocView:aView;
- docView;
- setDocCursor:anObj;
- (int)borderType;
- setBorderType:(int)aType;

// - setBackgroundGray:(float)value;
// - (float)backgroundGray;
// - setBackgroundColor:(NXColor)color;
// - (NXColor)backgroundColor;

- setVertScrollerRequired:(BOOL)flag;
- setHorizScrollerRequired:(BOOL)flag;
- vertScroller;
- horizScroller;

// - setVertScroller:anObject;
// - setHorizScroller:anObject;

- setLineScroll:(float)value;
- setPageScroll:(float)value;

// - setCopyOnScroll:(BOOL)flag;
// - setDisplayOnScroll:(BOOL)flag;
// - setDynamicScrolling:(BOOL)flag;

- setFrame:(const NXRect *)frameRect;
- tile;
- reflectScroll:cView;

// - write:(NXTypedStream *)stream;
- read:(NXTypedStream *)stream;
- awake;

- _scrollViaScroller:sender;
- _managedBy:parent wid:(void*)widget;

+ newFrame:(const NXRect *)frameRect;
+ new;

@end

@interface ScrollView(Ruler)
- toggleRuler:sender;
- ruler;
@end


#endif
