/* Interface for Text class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, and Paul Kunz (SLAC)
 *	    Mike L. Kienenberger (Alaska)
 *
 * This file is part of an Objective-C class library for a window system
 *
 * Text.h,v 1.9 1994/06/11 03:57:10 pfkeb Exp
 */

 
#ifndef _Text_h_
#define _Text_h_

#include "View.h"

/* justification modes */

#define NX_LEFTALIGNED 0
#define NX_RIGHTALIGNED 1
#define NX_CENTERED 2
#define NX_JUSTIFIED 3

@interface Text:View
{
	BOOL mono;
	BOOL editable;
	BOOL selectable;
	BOOL flipped;
}

- setMonoFont:(BOOL)flag;
- setEditable:(BOOL)flag;
- setSelectable:(BOOL)flag;
- setFlipped:(BOOL)flag;

- read:(TypedStream *)ts;

@end

#endif /* _Text_h_ */
