/* Implementation Text class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, and Paul Kunz (SLAC)
 *	    Mike L. Kienenberger (Alaska)
 *
 * This file is part of an Objective-C class library for a window system
 *
 * Text.m,v 1.6 1994/06/11 03:57:12 pfkeb Exp
 */


#include "Text.h"

@implementation Text

- setMonoFont:(BOOL)flag
{
	mono = flag;
	return self;
}

- setEditable:(BOOL)flag
{
	editable = flag;
	return self;
}

- setSelectable:(BOOL)flag
{
	selectable = flag;
	return self;
}

- setFlipped:(BOOL)flag
{
	flipped = flag;
	return self;
}

- read:(TypedStream *)ts;
{
	[super read:ts];
	
        objc_read_type( ts, "c", &mono );
        objc_read_type( ts, "c", &editable );
        objc_read_type( ts, "c", &selectable );
        objc_read_type( ts, "c", &flipped );
	
	return self;
}

- write:(TypedStream *)ts
{
    [super write:ts];
    return self;
}

@end
