/* Implementation of TextField class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, Imran Qureshi, and Libing Wang (SLAC)
 *	    Mike L. Kienenberger (Alaska)
 *
 * This file is part of an Objective-C class library for a window system
 *
 * TextField.m,v 1.31 1994/06/11 03:57:15 pfkeb Exp
 */

 
#include "TextField.h"

#include "TextFieldCell.h"

#include "stdmacros.h"

@implementation TextField : Control

- initFrame:(const NXRect *)frameRect
{
    if ( !cell )
        cell = [[TextFieldCell alloc] init]; 
    [super initFrame:frameRect];
    instancename = "TextField";
    return self;
}

- _initAsLabel
{
    if (!cell) {
	cell = [[TextFieldCell alloc] _initAsLabel];
    } else {
        [(TextFieldCell *)cell _initAsLabel];
    }
    return self;
}

- setTextGray:(float)value
{
    if (nil != cell)  [(TextFieldCell *)cell setTextGray:value];

    return self;
}

- read:(TypedStream *)ts
{
	int edit, select, bezel, border;
	
	[super read:ts];
	
	objc_read_types(ts, "iiii", &edit, &select, &bezel, &border);
	label = (!(edit || select || bezel || border));
	
	return self;
}

- write:(TypedStream *)ts
{
    [super write:ts];
    return self;
}

- awake
{
	[super awake];
        if (label)
          [(TextFieldCell *)cell _initAsLabel];

	return self;
}

@end
