/* Interface for View class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, Tom Pavel, 
 *	    Imran Qureshi, and Libing Wang
 *
 * This file is part of an Objective-C class library for a window system
 *
 * View.h,v 1.59 1994/06/15 20:27:17 fedor Exp
 */

 
#ifndef _View_h_
#define _View_h_

#include "Responder.h"
#include "graphics.h"
#include "Motif.h"	/* for XEvent */

/* Are we drawing, printing, or copying PostScript to the scrap? */

extern short XDrawingStatus();

/* XDrawingStatus values */

#define X_DRAWING	1	/* we're drawing */
#define X_PRINTING	2	/* we're printing */
#define X_COPYING	3	/* we're copying to the scrap */


/* compatibility macros */

#define NXDrawingStatus XDrawingStatus
#define NX_DRAWING X_DRAWING
#define NX_PRINTING X_PRINTING
#define NX_COPYING X_COPYING


@class List, Window;

@interface View:Responder
{
    NXRect 	frame;
    NXRect 	bounds;
    View        *superview;
    List   	*subviews;
    Window	*window;
    BOOL   	autoResize;
    BOOL	ancestorNotifyWasEnabled;
    BOOL	needsAncestorNotify;
    BOOL	focusLocked;	
    BOOL	validGState;
    BOOL	wantsGState;
    void 	*_drawingA;
    int		_gstate;
}

- init;
- initFrame:(const NXRect *)frameRect;
- free;

- addSubview:aView;
- addSubview:aView :(int)place relativeTo:otherView;
- replaceSubview:oldView with:newView;
- superview;
- removeFromSuperview;
 
- notifyAncestorWhenFrameChanged:(BOOL)flag;
- moveTo:(NXCoord)x :(NXCoord)y;
- moveBy:(NXCoord)deltaX :(NXCoord)deltaY;

- getBounds:(NXRect *)theRect;
- (BOOL)canDraw;
- (BOOL)lockFocus;
- unlockFocus;
- display:(const NXRect *)rects :(int)rectCount :(BOOL)clipFlag;
- display;
- drawSelf:(const NXRect *)rects :(int)rectCount;

- read:(TypedStream*)typedStream;
- awake;
- awakeFromNib;
- window;
- getFrame:(NXRect *)theRect;
- setFrame:(const NXRect *)frameRect;
- convertPoint:(NXPoint *)p fromView:aView;

- setAutoresizeSubviews:(BOOL)flag;
- display;
- display:(const NXRect *)rects :(int)rectCount;
- (int)gState;
- sizeTo:(NXCoord)width :(NXCoord)height;
- resizeSubviews:(const NXSize *)oldSize;
- descendantFrameChanged:sender;
- (NXRect *)frame;
- (void*)_widget;
- _addCallback;
- _managedBy:parent;
- _manageChildren;
- _setWindow:(Window *)aWindow;
- _setBorderRect:(NXRect *)brect;
@end

@interface View(WidgetSet)
#define SHIFT_MASK 1
#define CONTROL_MASK 2
- _init;
- (BOOL)_displayLockFocus;
- _displayUnlockFocus;
- _getFrame;
- _managedBy:parent wid:(void*)widget;
- _unManage;
- _destroy;
- makeNXEvent:(NXEvent *)nx fromXEvent:(XEvent *)event;
- _moveTo:(NXCoord)x :(NXCoord)y;
- _setFrame:(const NXRect *)aFrame;
- _setSize:(NXSize *)newSize;
- _setResize:(void *)policy;
- _setOffsets:(NXSize *)offsets;
- _setBorderShadow:(void *)shadow andThickness:(void *)thickness;
- _sizeTo:(NXCoord)width :(NXCoord)height;
@end
#endif /* _View_h_ */
