/* Interface for Window class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Fred Harris, Paul Kunz, Tom Pavel, 
 *	    Imran Qureshi, and Libing Wang (SLAC)
 *          Mike Kienenberger (Alaska)
 *
 * This file is part of an Objective-C class library for a window system
 *
 * Window.h,v 1.51 1994/06/15 18:58:44 pfkeb Exp
 */


#ifndef _Window_h_
#define _Window_h_

#include "Responder.h"
#include "graphics.h"
#include "screens.h"

@class Menu, View;
@interface Window:Responder
{
    NXRect 	frame;
    View	*contentView;
    id          delegate;
    BOOL 	isVisible;
    BOOL	isMainWindow;
    BOOL	isKeyWindow;
    BOOL	isPanel;
    
    Menu	*menu;
    id   	verticalScrol;
    id 	        horizontalScrol;
    char	*title;
    void 	*_shell;
    BOOL 	hasMenu;
    BOOL 	hasScroller;
    BOOL 	displaying;   //  is displaying enabled or disabled?...slf
    BOOL 	edited;
    BOOL	_limitedBecomeKey;
    BOOL	_floatingPanel;
    BOOL	hasRealized;	/* YES if wiget has ever been realized */
}

+ alloc;
- init;
- initContent:(const NXRect *)contentRect;
- initContent:(const NXRect *)contentRect style:(int)aStyle
					backing:(int)bufferingType
					buttonMask:(int)mask
					defer:(BOOL)flag;

- initContent:(const NXRect *)contentRect style:(int)aStyle
					backing:(int)bufferingType
					buttonMask:(int)mask
					defer:(BOOL)flag
					screen:(const NXScreen *)screen;

// - free;

- awake;
- setTitle:(const char*)aString;
- setTitleAsFilename:(const char *)aString;

// - setExcludedFromWindowsMenu:(BOOL)flag;
// - (BOOL)isExcludedFromWindowsMenu;

- setContentView:aView;
- contentView;
- setDelegate:newDelegate;
- delegate;
- (const char*)title;

// - (int)buttonMask;
// - (int)windowNum;
// - getFieldEditor:(BOOL)createFlag for:anObject;
// - endEditingFor:anObject;
// - placeWindowAndDisplay:(const NXRect *)frameRect;

- placeWindow:(const NXRect *)frameRect;

// - placeWindow:(const NXRect *)frameRect screen:(const NXScreen *)screen;
// - (BOOL)constrainFrameRect:(NXRect *)frameRect 
//                   toScreen:(const NXScreen *)screen;

- sizeWindow:(NXCoord)width :(NXCoord)height;

// - moveTo:(NXCoord)x :(NXCoord)y;
// - moveTopLeftTo:(NXCoord)x :(NXCoord)y;
// - moveTo:(NXCoord)x :(NXCoord)y screen:(const NXScreen *)screen;
// - moveTopLeftTo:(NXCoord)x :(NXCoord)y screen:(const NXScreen *)screen;

- getFrame:(NXRect *)theRect;

// - getFrame:(NXRect *)rect andScreen:(const NXScreen **)screen;
// - getMouseLocation:(NXPoint *)thePoint;
// - (int)style;
// - useOptimizedDrawing:(BOOL)flag;

- disableFlushWindow;
- reenableFlushWindow;

// - (BOOL)isFlushWindowDisabled;

- flushWindow;

// - flushWindowIfNeeded;

- disableDisplay;
- reenableDisplay;

// - (BOOL)isDisplayEnabled;

- displayIfNeeded;
- display;
- update;

// - (int)setEventMask:(int)newMask;
// - (int)addToEventMask:(int)newEvents;
// - (int)removeFromEventMask:(int)oldEvents;
// - (int)eventMask;
// - setTrackingRect:(const NXRect *)aRect inside:(BOOL)insideFlag 
//             owner:anObject tag:(int)trackNum 
//              left:(BOOL)leftDown right:(BOOL)rightDown;
// - discardTrackingRect:(int)trackNum;

- makeFirstResponder:aResponder;
- firstResponder;

// - sendEvent:(NXEvent *)theEvent;
// - windowExposed:(NXEvent *)theEvent;
// - windowMoved:(NXEvent *)theEvent;
// - screenChanged:(NXEvent *)theEvent;
// - (int)resizeFlags;

- makeKeyWindow;

// - becomeKeyWindow;
// - resignKeyWindow;

- becomeMainWindow;
- resignMainWindow;

// - displayBorder;
// - rightMouseDown:(NXEvent *)theEvent;
// - (BOOL)commandKey:(NXEvent *)theEvent;

- close;

// - setFreeWhenClosed:(BOOL)flag;
// - miniaturize:sender;
// - deminiaturize:sender;
// - (BOOL)tryToPerform:(SEL)anAction with:anObject;
// - validRequestorForSendType:(NXAtom)sendType 
//               andReturnType:(NXAtom)returnType;
// - setBackgroundGray:(float)value;
// - (float)backgroundGray;
// - setBackgroundColor:(NXColor)color;
// - (NXColor)backgroundColor;
// - dragFrom:(float)x :(float)y eventNum:(int)num;
// - setHideOnDeactivate:(BOOL)flag;
// - (BOOL)doesHideOnDeactivate;
// - center;

- makeKeyAndOrderFront:sender;
- orderFront:sender;
- orderBack:sender;
- orderOut:sender;

// - orderWindow:(int)place relativeTo:(int)otherWin;
// - orderFrontRegardless;
// - setMiniwindowIcon:(const char *)anIcon;
// - setMiniwindowImage:image;
// - setMiniwindowTitle:(const char *)title;
// - (const char *)miniwindowIcon;
// - (NXImage *)miniwindowImage;
// - (const char *)miniwindowTitle;

- setDocEdited:(BOOL)flag;
- (BOOL)isVisible;
- (BOOL)isKeyWindow;
- (BOOL)isMainWindow;

// - (BOOL)canBecomeKeyWindow;

- (BOOL)canBecomeMainWindow;

// - (BOOL)worksWhenModal;
// - convertBaseToScreen:(NXPoint *)aPoint;
// - convertScreenToBase:(NXPoint *)aPoint;

- performClose:sender;

// - performMiniaturize:sender;

- (int)gState;

// - setOneShot:(BOOL)flag;
// - (BOOL)isOneShot;
// - faxPSCode:sender;
// - printPSCode:sender;
// - copyPSCodeInside:(const NXRect *)rect to:(NXStream *)stream;
// - smartFaxPSCode:sender;
// - smartPrintPSCode:sender;
// - (BOOL)knowsPagesFirst:(int *)firstPageNum last:(int *)lastPageNum;
// - openSpoolFile:(char *)filename;
// - beginPSOutput;
// - beginPrologueBBox:(const NXRect *)boundingBox 
//        creationDate:(const char *)dateCreated 
//           createdBy:(const char *)anApplication 
//               fonts:(const char *)fontNames forWhom:(const char *)user 
//               pages:(int)numPages title:(const char *)aTitle;
// - endHeaderComments;
// - endPrologue;
// - beginSetup;
// - endSetup;
// - beginPage:(int)ordinalNum label:(const char *)aString 
//        bBox:(const NXRect *)pageRect fonts:(const char *)fontNames;
// - beginPageSetupRect:(const NXRect *)aRect 
//            placement:(const NXPoint *)location;
// - endPageSetup;
// - endPage;
// - beginTrailer;
// - endTrailer;
// - endPSOutput;
// - spoolFile:(const char *)filename;
// - (float)heightAdjustLimit;
// - (float)widthAdjustLimit;
// - (BOOL)getRect:(NXRect *)theRect forPage:(int)page;
// - placePrintRect:(const NXRect *)aRect offset:(NXPoint *)location;
// - addCursorRect:(const NXRect *)aRect cursor:anObj forView:aView;
// - removeCursorRect:(const NXRect *)aRect cursor:anObj forView:aView;
// - disableCursorRects;
// - enableCursorRects;
// - discardCursorRects;
// - invalidateCursorRectsForView:aView;
// - resetCursorRects;
// - setBackingType:(int)bufferingType;
// - (int)backingType;
// - setAvoidsActivation:(BOOL)flag;
// - (BOOL)avoidsActivation;
// - setDepthLimit:(NXWindowDepth)limit;
// - (NXWindowDepth)depthLimit;
// - setDynamicDepthLimit:(BOOL)flag;
// - (BOOL)hasDynamicDepthLimit;
// - (const NXScreen *)screen;
// - (const NXScreen *)bestScreen;
// - (BOOL)canStoreColor;
// - counterpart;
// - (void)saveFrameToString:(char *)string;

- (void)setFrameFromString:(const char *)string;

// - (void)saveFrameUsingName:(const char *)name;
// - (BOOL)setFrameUsingName:(const char *)name;

- (BOOL)setFrameAutosaveName:(const char *)name;

// - (const char *)frameAutosaveName;
// + (void)removeFrameUsingName:(const char *)name;
// - getMinSize:(NXSize *)size;
// - getMaxSize:(NXSize *)size;
// - setMinSize:(const NXSize *)size;
// - setMaxSize:(const NXSize *)size;
// - write:(NXTypedStream *)stream;

- read:(NXTypedStream *)stream;

- setHasMenu:(BOOL)menuFlag hasScroller:(BOOL)scrolFlag;

- setMenu:(id)menu;

/*  Archiving methods */
- awakeFromNib;

@end

/* Window delegate methods.
 * There are declared here as if Object implements them.
 * This is just to keep the compiler happy when it tries to find method name.   
 */

@interface Object(WindowDelegate)
- windowWillClose:sender;
- windowWillReturnFieldEditor:sender toObject:client;
- windowWillResize:sender toSize:(NXSize *)frameSize;
- windowDidResize:sender;
- windowDidExpose:sender;
- windowWillMove:sender;
- windowDidMove:sender;
- windowDidBecomeKey:sender;
- windowDidResignKey:sender;
- windowDidBecomeMain:sender;
- windowDidResignMain:sender;
- windowWillMiniaturize:sender toMiniwindow:miniwindow;
- windowDidMiniaturize:sender;
- windowDidDeminiaturize:sender;
- windowDidUpdate:sender;
- windowDidChangeScreen:sender;
@end

@interface Window(WidgetSet)
- _setTitle;
- _initContent:(const NXRect *)contentRect;
- _setWindowAreas;

// - closeWindow;

- _realize;
- (BOOL) _hasRealized;
- (void *)_widget;
- (void *)_shell;
@end

#endif /* _Window_h_ */
