/* Implementation of Window class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, Tom Pavel, 
 *	    Imran Qureshi, and Libing Wang (SLAC)
 *          Mike Kienenberger (Alaska)
 *
 * This file is part of an Objective-C class library for a window system
 *
 * Window.m,v 1.96 1994/06/15 18:58:47 pfkeb Exp
 */


#include "Window.h"

/* Required for implementation: */

#include "Application.h"
#include "Menu.h"
#include "Responder.h"
#include "CustomView.h"
#include <coll/List.h>
#include <stdlib.h>             /* for free() */
#include "Scroller.h"
#include <stdio.h>
#include <objc2/typedstream2.h>

extern char *WindowInstanceName( void );

@implementation Window

/* Factory methods */

+ alloc
{
    self = [super alloc];
    [[NXApp windowList] addObject: self];
    return self;
}


/* Public methods */

- init
{
    NXRect  defaultRect = { {0, 0}, {612, 792} };
            
    [self initContent:&defaultRect];
    return self;
}

- initContent:(const NXRect *)contentRect 
{
    return [self initContent:contentRect style:0
					backing:0
					buttonMask:0
					defer:YES
					screen:(const NXScreen *)NULL];
}

- initContent:(const NXRect *)contentRect style:(int)aStyle
					backing:(int)bufferingType
					buttonMask:(int)mask
					defer:(BOOL)flag
{
    return [self initContent:contentRect style:aStyle
					backing:0
					buttonMask:bufferingType
					defer:mask
					screen:(const NXScreen *)NULL];
}

- initContent:(const NXRect *)contentRect style:(int)aStyle
					backing:(int)bufferingType
					buttonMask:(int)mask
					defer:(BOOL)flag
					screen:(const NXScreen *)screen
{
    View	*aView;
    NXRect	frameRect;
    
    [super init];
    instancename = WindowInstanceName();
    if ( !title ) {
        title = NXCopyStringBuffer("Untitled");
    }

    [self _initContent:contentRect];    

    frameRect.origin.x = 0;
    frameRect.origin.y = 0;
    frameRect.size.height = NX_HEIGHT(contentRect);
    frameRect.size.width  = NX_WIDTH(contentRect);
    aView = [[View alloc] initFrame:&frameRect];
    [self setContentView:aView];

    return self;
}

- setHasMenu:(BOOL)menuFlag hasScroller:(BOOL)scrolFlag
{
	hasMenu = menuFlag;
    	hasScroller = scrolFlag;
	return self;
}

- free
{
    if (title) {
	free(title);
    }
    return [super free];
}

- setTitle:(const char*)aString
{
    if ( title ) { 
        free(title);
    }
    title = NXCopyStringBuffer(aString);
    [self _setTitle];
    return self;
}

- (const char *)title;
{

    return title;
}

- setContentView:aView
{
    View	*temp;

    temp = contentView;
    [temp _setWindow:nil];
    contentView = aView;
    [aView _setWindow:self];
    return temp;
}

- setMenu:(id)aMenu
{
    menu = aMenu;
    hasMenu = YES;
    [self _setWindowAreas];
    return self;
}

- contentView
{
    return contentView;
}

- delegate
{
    return delegate;
}

- setDelegate:newDelegate
{
    delegate = newDelegate;
    return self;
}

- becomeMainWindow
{
    isMainWindow = YES;
    if ( delegate && [delegate respondsTo:@selector(windowDidBecomeMain:) ] ) {
	[delegate windowDidBecomeMain:self];
    }    
    return self;
}
- resignMainWindow
{
    isMainWindow = NO;
    if ( delegate && [delegate respondsTo:@selector(windowDidResignMain:) ] ) {
	[delegate windowDidResignMain:self];
    }
    return self;
}

- orderFront:sender
{
    [self _setWindowAreas];
    [NXApp _willBecomeMain:self];
    isVisible = YES;
    [self _realize];
    return self;
}

- orderBack:sender
{
    return self;
}

- makeKeyAndOrderFront:sender
{
    [self makeKeyWindow];
    [self orderFront:self];
    return self;
}

- getFrame:(NXRect *)theRect
{
	theRect = &frame;
	return self;
}

- performClose:sender
{
	[self close];
	return self;
}

- setDocEdited:(BOOL)flag
{
	edited = YES;
	return self;
}

- (BOOL)isDocEdited
{
	return edited;
}

- (BOOL)isVisible
{
    return isVisible;
}

- (BOOL)isKeyWindow
{
    return isKeyWindow;
}
- (BOOL)isMainWindow
{
    return isMainWindow;
}

// - (BOOL)canBecomeKeyWindow; 
- (BOOL)canBecomeMainWindow
{
    if ( isPanel ) {
        return NO;
    }
    return YES;
}
// - (BOOL)worksWhenModal;
// - convertBaseToScreen:(NXPoint *)aPoint;
// - convertScreenToBase:(NXPoint *)aPoint;

- placeWindow:(const NXRect *)frameRect
 /*  	There very well may be a subtlety to this function that we are
	missing or didn't notice in NeXT docs...
 */
{
	frame.size.height = frameRect->size.height;
	frame.size.width = frameRect->size.width;
	frame.origin.x = frameRect->origin.x;
	frame.origin.y = frameRect->origin.y;
	return self;
}

- (void)setFrameFromString:(const char *)frameString
{
    sscanf(frameString, "%d%d%d%d", 
    			&(frame.origin.x), &(frame.origin.y),
    			&(frame.size.width), &(frame.size.height));
    return;
}

- read:(TypedStream*)typedStream
{
        [super read:typedStream];
        NXReadRect(typedStream,&frame);
        objc_read_string(typedStream,&title);
       	objc_read_object(typedStream,&contentView);
        objc_read_type( typedStream, "c", &isVisible );
        return self;
}

- awake
{
    if (widgetid)
	return self;
    [self _initContent:&frame];
    [[NXApp windowList] addObject: self];
    return self;
}

- awakeFromNib
{
   View	*custom;
 /*
  * what's implmented here is that which has to wait until all objects in the
  * heirarchy get a chance to receive their awake method. 
  */
    if ( [contentView isKindOf:[CustomView class]] ) {
        custom = contentView;
        contentView = [(CustomView *)custom nibInstantiate];
	[custom free];
    } else {
	[contentView awakeFromNib];
    } 
    [contentView _setWindow:self];
    if ( isVisible ) {
        [self orderFront:nil];
    }
    return self;
}


- makeKeyWindow
{
	return self;
}


- close
{
    if (delegate && [delegate respondsTo:@selector(windowWillClose:)])
    {
    	if (![delegate perform:@selector(windowWillClose:) with:self])
		 return nil;
    }		
    return self;
    
}

- makeFirstResponder:aResponder
{
	return self;
}


- setTitleAsFilename:(const char *)aString
{
	return self;
}

- firstResponder
{
	return self;
}

- disableDisplay
{
	displaying = NO;
	return self;
}

- reenableDisplay
{
	displaying = YES;
	return self;
}


- displayIfNeeded
{
 /* Probably don't need this method under X */
    return self;
}

- display
{
    return self;
}

- update
{
    if ( delegate && [delegate respondsTo:@selector(windowDidUpdate:) ] ) {
	[delegate windowDidUpdate:self];
    }
    return self;
}

- sizeWindow:(NXCoord)width :(NXCoord)height
/*
	Checks for delegate method first, if delegate returns anything
	other than nil, execute resize code.
	NOTE: there is some code here, but this is not a fully
	functional method.  It doesn't handle subviews at all for
	instance!
 */
{
//	Here we would need to resize subviews of this window accordingly...
//	we may not support this...
    NXSize temp;
    temp.width = width;
    temp.height = height;
    if (delegate && [delegate respondsTo:@selector(windowWillResize:toSize:)] 
    	&& ([delegate perform:@selector(windowWillResize:)
				 with:self with:(id)&temp]))
    {
    
    	frame.size.width = width;
    	frame.size.height = height;
    	return self;
    }
    return self;
}
/*      I don't think we'll need this.  Returns the ps graphics state
	object of the window.  Doesn't sound like an X-feature...slf
*/ 


- (int)gState
{
	return 0;
}

- flushWindow
{
    return self;
}

- disableFlushWindow
{
    return self;
}
- reenableFlushWindow
{
    return self;
}

- orderOut:sender
{
	return self;
}

- (BOOL)setFrameAutosaveName:(const char *)name
{
 /*
  * This fancy feature we don't need now.   Wasn't even in NeXTSTEP until 3.0 
  */
    return NO;
}
@end

