/*
    tiff - Functions for dealing with tiff images

    Copyright (C) 1994, Adam Fedor.

    Warning:  This header file should not be used for reading and
    writing tiff files.  You should use the NXImage and NXBitmapImageRep
    classes for general reading/writting of tiff files.
*/

#ifndef _GNUTSTEP_TIFF_H_
#define _GNUTSTEP_TIFF_H_

#ifdef HAVE_LIBTIFF
#include <tiffio.h>
#else
#define TIFF void
#endif
#include <sys/types.h>

/*
 * Structure to store common information about a tiff
 */
typedef struct {
    u_long  imageNumber;
    u_long  subfileType;
    u_long  width;
    u_long  height;
    u_short bitsPerSample;	/* number of bits per data channel */
    u_short samplesPerPixel;	/* number of channels per pixel */
    u_short planarConfig;	/* meshed or separate */
    u_short photoInterp;	/* photometric interpretation of bitmap data, */
    u_short compression;
    int     numImages;		/* number of images in tiff */
    int     error;
} NXTiffInfo; 

typedef struct {
    u_int    size;
    u_short *red;
    u_short *green;
    u_short *blue;
} NXColormap;

extern TIFF *NXOpenTiffFile(const char *filename, int mode);
extern TIFF *NXOpenTiffStream(NXStream *stream, int mode);
extern int  NXCloseTiff(TIFF *image);

extern NXTiffInfo *NXGetTiffInfo(int imageNumber, TIFF *image);
extern void *NXReadTiff(int imageNumber, TIFF *image, NXTiffInfo *info, void *data);
extern int  NXWriteTiff(TIFF *image, NXTiffInfo *info, void *data);

extern NXColormap *NXGetColormap(TIFF *image);

#endif
