/* X/Motif WidgetSet category implementation of  Cell class
 *
 * Copyright (C)  1994  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Fred Harris, Paul Kunz,
 *          Imran Qureshi, and Libing Wang
 * At: Stanford Linear Accelerator Center, Stanford University and
 *     University of Hawaii
 *
 * This file is part of an Objective-C class library for X/Motif
 *
 * xmCell.m,v 1.2 1994/06/11 00:39:21 pfkeb Exp
 */

#include "Cell.h"

#include <stdlib.h>
#include "Motif.h"
#include <Xm/PushB.h>
#define Window X11Window
#include <X11/IntrinsicP.h>
#undef Window
#include <stdio.h>

char *CellInstanceName(void)
{
    return "Cell";
}

/* Private methods of Motif interface */

@implementation Cell(WidgetSet)

- _moveTo:(NXCoord)x :(NXCoord)y
{
    XtMoveWidget(widgetid, x, y);
    return self;
}

- _setEnabled:(BOOL)flag
{
    [self _setArg:XmNsensitive to:(void*)&flag];
    return self;
}

- _setFrame:(const NXRect *)frame
{
    _frame.origin.x    = frame->origin.x;
    _frame.origin.y    = frame->origin.y;
    _frame.size.width  = frame->size.width;
    _frame.size.height = frame->size.height;
    [self _setArg:XmNx      to:(void *)_frame.origin.x];
    [self _setArg:XmNy      to:(void *)_frame.origin.y];
    [self _setArg:XmNwidth  to:(void *)_frame.size.width];
    [self _setArg:XmNheight to:(void *)_frame.size.height];
    return self;
}

- _setSize:(const NXSize *)size
{
    _frame.size.width = size->width;
    _frame.size.height = size->height;
    [self _setArg:XmNwidth  to:(void *)_frame.size.width];
    [self _setArg:XmNheight to:(void *)_frame.size.height];
    [self _setArg:XmNrecomputeSize to:(void *)False];
    return self;
}
- _getFrame:(NXRect *)frame
{
    [self _getArg:XmNx 	    into:&frame->origin.x];
    [self _getArg:XmNy	    into:&frame->origin.y];
    [self _getArg:XmNwidth  into:&frame->size.width];
    [self _getArg:XmNheight into:&frame->size.height];
    return self;
}
- _addArg:(const char *)name :(void *)value
{
    Arg *args = arglist;
    if (++numargs > allocedargs ) {
	allocedargs = (allocedargs) ? 2*allocedargs : 10;
	/* XtRealloc handles error checking and calling malloc if args
	   is NULL  */ 
	args = arglist = XtRealloc(arglist, (allocedargs)*sizeof(Arg));
    }
    args[numargs-1].name = (char *)(name);
    args[numargs-1].value = (XtArgVal) value;
    return self;
}
- _setArg:(const char*)name to:(void*)value
{
    if (widgetid) {
	XtVaSetValues(widgetid, name, value, NULL);
    } else {
	[self _addArg:name :value];
    }
    return self;
}

- _getArg:(const char*)name into:(void*)value
{
    if (widgetid) {
	XtVaGetValues(widgetid, name, value, NULL);
    } else {
	fprintf(stderr,"What? no id? in Cell\n");
    }
    return self;
}

- _addCallback
{
    return self;
}

- _managedBy:parent
{
    Widget widparent;

    if (!(widparent = [parent _widget]))
        if ( ![parent respondsTo:@selector(superview)] ||
              !(widparent = 
	         [[parent perform:@selector(superview)] _widget] ) ) {
            fprintf(stderr, "Cell: parent widget not found\n");
            return 0;
        }
    [self _managedBy:parent wid:widparent];

    return self;
}    

- _managedBy:parent wid:(void *)widget;
{
    if (!classname) {
        fprintf(stderr, "Cell classname unknown\n");
    }
    if (widgetid) {
        XtManageChild(widgetid);
    } else {
	if ( !contents ) {
	  /* if no contents yet, then make default */
	    [self setStringValue:" "];
	}
	widgetid = XtCreateManagedWidget(instancename, classname,
				     widget, arglist, numargs);
	[self _addCallback];
    }	
    parentid = parent;
    return self;
}

- _destroy
{
    if ( widgetid ) {
        XtDestroyWidget(widgetid);
    }
    widgetid = NULL;
    return self;
}    
- (void *)_widget
{
    return widgetid;
}

@end
