/* Motif WidgetSet category for implementation of FormCell class
 *
 * Copyright (C)  1994  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, Imran Qureshi, and Libing Wang
 *
 * This file is part of an Objective-C class library for X/Motif
 *
 * xmFormCell.m,v 1.1 1994/06/14 00:30:04 pfkeb Exp
 */

#include "FormCell.h"

#include "Motif.h"
#include "TextFieldCell.h"
#include <Xm/Label.h>
#include <Xm/BulletinB.h>

char *FormCellInstanceName(void)
{
    return "FormCell";
}

@implementation FormCell(WidgetSet)

- _init
{
    classname = xmBulletinBoardWidgetClass;
    [self _addArg:XmNmarginWidth :(void*)0];
    [self _addArg:XmNmarginHeight :(void*)0];
    return self;
}

- (NXCoord)_titleWidth
{
    Dimension strWidth = 0;

    if ([titleCell _widget])
       XtVaGetValues([titleCell _widget], XmNwidth, &strWidth, NULL);

    return (NXCoord)strWidth;
}

@end
