/* Motif WidgetSet category for implementation of Menu class
 *
 * Copyright (C)  1994  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, Tom Pavel, Imran Qureshi,
 *	    and Libing Wang (SLAC)
 *	    Mike Kienenberger (Alaska)
 *
 * This file is part of an Objective-C class library for X/Motif
 *
 * xmMenu.m,v 1.1 1994/06/14 01:54:37 pfkeb Exp
 *
 */

#include "Menu.h"

/* Required for implementation: */
#include "Motif.h"
#include <Xm/RowColumn.h>	/* for XmCreateMenuBar and
				 * XmCreatePulldownMenu */
#include "MenuCell.h"
// #include "Application.h"
#include "Matrix.h"
#include <coll/List.h>
// #include <stdio.h>

char *MenuInstanceName(void)
{
    return "Menu";
}

@implementation Menu(WidgetSet)

- _init
{
    classname = xmPrimitiveWidgetClass;
    return self;
}
- _managedBy:parent wid:(void*)widget
/* 
	Creates the menu, pulldown, etc.  The problem with this implementation,
	as I see it, is that it's implementation depends on the developer
	only creating one "MENU", ie the main menu of the app, and that
	all other menus are submenus, in fact.  This clearly needs to 
	be more general to allow multiple menus to be created.  Its just not
	good functionality for a library of classes.
 */
{
    List	*cellList = [matrix cellList];
    int		i, count;
/*
 * This line is key!  It is what creates the dependency on the
 * NXApp for its main menu!     
 */
    if ([self _isMain]) {
  /*  Creates the menubar across top of window */
	widgetid = XmCreateMenuBar(widget, instancename,
				   [self _arglist], [self _numargs]);
	XtManageChild(widgetid);
    } else {
  /*  Creates submenus that pull down... */
	widgetid = XmCreatePulldownMenu(widget, instancename,
					[self _arglist], [self _numargs]);
    }

 /* The order is important */
    count = [cellList count];
    for ( i = 0; i < count; i++ ) {
	[[cellList objectAt:i] _managedBy:self];
    }

    if (_helpSubmenu) {
	XtVaSetValues(widgetid,
		      XmNmenuHelpWidget, [_helpSubmenu _widget],
		      NULL);
    }
    return self;
}

@end
