// GNUStep category for Responder class

// Copyright (C) 1993 The Board of Trustees of  
// The Leland Stanford Junior University.  All Rights Reserved.

// Authors: Scott Francis, Paul Kunz, and Libing Wang

#include "Responder.h"

#include "Motif.h"
#include <stdio.h>

char *
ResponderInstanceName( void ) 
{
    return "Responder";
}

@implementation Responder(WidgetSet)
- _addArg:(const char *)name :(void *)value
{
    Arg 	*args;

    args = arglist;
    if ((numargs+=1) > allocedargs ) {
	allocedargs = (allocedargs) ? 2*allocedargs : 10;
	/* XtRealloc handles error checking and calling malloc if args
	   is NULL  */ 
	args = arglist = XtRealloc(arglist, (allocedargs)*sizeof(Arg));
    }
    args[numargs-1].name = (char *)(name);
    args[numargs-1].value = (XtArgVal) value;
    return self;
}

- _setArg:(const char*)name to:(void*)value
{
    if (widgetid) {
	XtVaSetValues(widgetid, name, value, NULL);
    } else {
	[self _addArg:name :value];
    }
    return self;
}

- _getArg:(const char *)name into:(void *)value
{
    if (widgetid) {
    	XtVaGetValues(widgetid, name, value, NULL);
    } else {
	fprintf(stderr,"Responder: no widgetid in getarg\n");
    }
    return self;
}

- (void *)_arglist
{
    return arglist;
}

- (int)_numargs
{
    return numargs;
}

- _setnumargs:(int)val
{
    numargs = val;
    return self;
}
@end


