/* Motif WidgetSet category for implementation of SavePanel class
 *
 * Copyright (C)  1993, 1994  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Fred Harris, Paul Kunz, Tom Pavel, 
 *	    Imran Qureshi, and Libing Wang
 *
 * This file is part of an Objective-C class library for X/Motif
 *
 * xmSavePanel.m,v 1.2 1994/06/14 20:36:56 pfkeb Exp
 */


#include "SavePanel.h"

/* Required for implementation: */
#include "Motif.h"
#include "Application.h"
#include <Xm/FileSB.h>
#include <Xm/PushB.h>

static void
theCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
    XmFileSelectionBoxCallbackStruct *cb
        = (XmFileSelectionBoxCallbackStruct *) call_data;

    switch (cb->reason) {
    case XmCR_OK:
	[NXApp stopModal:1];
	break;
    case XmCR_CANCEL:
	[NXApp stopModal:0];
	break;
    default:
    }
}

char *SavePanelInstanceName(void)
{
    return "SavePanel";
}

@implementation SavePanel(WidgetSet)

- _init
{
#define XtUnman (void (*)(Widget, XtPointer, XtPointer))

//    [super init]; Don't use Window's method!
//		    Create widget here instead

    if (!widgetid) {
	widgetid = XmCreateFileSelectionDialog([NXApp _toplevel],
					       "File_Selection", NULL, 0);
	XtVaSetValues(widgetid, XmNdialogStyle, XmDIALOG_SYSTEM_MODAL, NULL);
	XtAddCallback(widgetid, XmNokCallback,     theCallback, self);
	XtAddCallback(widgetid, XmNcancelCallback, theCallback, self);
	XtAddCallback(widgetid, XmNokCallback, XtUnman XtUnmanageChild, NULL);
	XtAddCallback(widgetid, XmNcancelCallback,
	                        XtUnman XtUnmanageChild, NULL);
    }
    return self;
}

- _manageAndPopup
{
    XtManageChild(widgetid);
    XtPopup( XtParent(widgetid), XtGrabNone);
    return self;
}

- (const char *)_filename
{
    XmString	temp;
    
    XtVaGetValues(widgetid, XmNdirSpec, &temp, NULL);
    XmStringGetLtoR(temp, XmSTRING_DEFAULT_CHARSET, &filename);
    return filename;
}


- _setDirectory:(const char *)path
{
   [self _setArg:XmNdirectory to:(char *)path];
   return self;
}

- _setTitle:(const char *)aTitle
{
    [self _setArg:XmNlabelString to:title];
    return self;
}

- _setRequiredFileType:(const char *)type
{
   [self _setArg:XmNpattern to:(char *)type];
   return self;
}

- _managedBy:parent wid:(void*)widget
{
    XtAddCallback(widgetid, XmNokCallback,     theCallback, self);
    XtAddCallback(widgetid, XmNcancelCallback, theCallback, self);
    return self;
}

@end
