/*
    NXCachedImageRep - wrapped for cashing images

    Copyright (c) 1994, Adam Fedor.

    Implementation of display specific methods for X/Motif.
*/

#include "NXCachedImageRep.h"
#include "Motif.h"
#include "Application.h"
#include "Window.h"

const char *NXCachedImageRepInstanceName(void)
{
    return "NXCachedImageRep";
}

@implementation NXCachedImageRep(ToolKit)

/* Copy the contents of our window to the lock-focused window */
- (BOOL)_displayDraw
{
    XMotifContext context;
    Drawable	  source;

    context = (XMotifContext)[NXApp context];
    if (!context->gstate->widget) {
	fprintf(stderr, "CachedImage: Focus not locked on any view\n");
	return NO;
    }
    if (!context->gstate->xgstate) {
	fprintf(stderr, "CachedImage: No gstate.\n");
	return NO;
    }
    source = XtWindow((Widget)[_window perform:@selector(_shell)]);
    XCopyPlane(context->display, 
		source,
		XtWindow(context->gstate->widget),
		context->gstate->xgstate,
		NX_X(&_rect),
		NX_Y(&_rect),
		NX_WIDTH(&_rect),
		NX_HEIGHT(&_rect),
		context->gstate->origin.x,
		context->gstate->origin.y,
		1);

    return YES;
}

@end
