/*
    NXImage - class to load an manipulate images

    Copyright (C) 1993, Adam Fedor. 

    xtNXImage.m,v 1.2 1994/06/15 20:27:28 fedor Exp
    
   Implementation of display specific methods for X/Motif.
*/

#include "NXImage.h"

#include "Motif.h"
#include "Application.h"
#include <string.h>

const char *NXImageInstanceName(void)
{
    return "NXImage";
}

@implementation NXImage(ToolKit)

- _displayComposite:(int)op fromRect:(const NXRect *)rect 
	toPoint:(const NXPoint *)point
{
    NXRect newrect;
    newrect = *rect;
    NX_WIDTH(&newrect) += point->x;
    NX_HEIGHT(&newrect) += point->y;
    return ([self drawRepresentation:[self bestRepresentation]
                  inRect:&newrect])
		? self : nil;
}

- (BOOL)_displayLockFocusOn:(NXImageRep *)imageRepresentation
{
    XMotifContext context;

    context = (XMotifContext)[NXApp context];
    if (context->gstate->widget) {
        fprintf(stderr, "NXImage: Focus already locked.\n");
        return NO;
    }
    context->gstate->widget = NULL;
    return (context->gstate->widget) ? YES : NO;
}

- _displayUnlockFocus
{
    XMotifContext context;

    context = (XMotifContext)[NXApp context];
    if (context->gstate->widget) {
        fprintf(stderr, "NXImage: Focus not locked. \n");
        return nil;
    }
    context->gstate->widget = NULL;
    return self;
}

@end
