/*
    NXImageRep.m - Abstract image representation.

    Copyright (c) 1993, Adam Fedor. 

   Implementation of display specific methods for X/Motif
*/

#include "NXImageRep.h"

#include "Application.h"
#include "Motif.h"

const char *NXImageRepInstanceName(void)
{
    return "NXImageRep";
}


@implementation NXImageRep(WidgetSet)

- (BOOL)_displayDrawAt:(const NXPoint *)point
{
    XMotifContext context;
//    XImage        *image;

    context = (XMotifContext)[NXApp context];
    if (!context->gstate->widget) {
        fprintf(stderr, "ImageRep: Focus not locked on any view\n");
        return NO;
    }
    if (!context->gstate->xgstate) {
        fprintf(stderr, "ImageRep: No gstate.\n");
        return NO;
    }
    context->gstate->origin.x += point->x;
    context->gstate->origin.y += point->y;
    return YES;
}

@end
