/* General purpose definitions for the Collection Library.
   Copyright (C) 1993 Free Software Foundation, Inc.

   Written by:  R. Andrew McCallum <mccallum@cs.rochester.edu>
   Dept. of Computer Science, U. of Rochester, Rochester, NY  14627

   This file is part of the GNU Objective-C Collection library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/ 

#ifndef __collstd_h_INCLUDE_GNU
#define __collstd_h_INCLUDE_GNU

#include <coll/objc-gnu2next.h>
#include <objc/Object.h>
#include <coll/objc-malloc.h>

/* The following two lines are maintained by the libcoll Makefile */
#define COLL_VERSION 940510
#define COLL_GCC_VERSION 2.5.8

extern const char coll_version[];
extern const char coll_gcc_version[];
#ifdef NeXT
extern const char coll_NeXT_cc_version[];
#endif

#define LAMBDA(RETTYPE, ARGS, BODY) \
({RETTYPE __lambda_func ARGS BODY __lambda_func;})

#define LAMBDA_VOID_PERFORM(SELECTOR) \
LAMBDA(void, (id _o), {[_o perform: SELECTOR];})

#define LAMBDA_ID_PERFORM(SELECTOR) \
LAMBDA(id, (id _o), {return [_o perform: SELECTOR];})

#define LAMBDA_BOOL_PERFORM(SELECTOR) \
LAMBDA(BOOL, (id _o), {if ([_o perform:SELECTOR]) return YES; else return NO;})


#ifndef MAX
#define MAX(a,b) \
       ({typedef _ta = (a), _tb = (b);  \
         _ta _a = (a); _tb _b = (b);     \
         _a > _b ? _a : _b; })
#endif

#ifndef MIN
#define MIN(a,b) \
       ({typedef _ta = (a), _tb = (b);  \
         _ta _a = (a); _tb _b = (b);     \
         _a < _b ? _a : _b; })
#endif

/* I'd like this memory allocation stuff to be put somewhere more general. */

/* I do this to make substituting Boehm's Garbage Collection easy. 
   Perhaps I should others too, like objc_atomic_malloc(), etc. */
extern void *(*objc_malloc)(size_t);
extern void *(*objc_realloc)(void *, size_t);
extern void *(*objc_calloc)(size_t, size_t);
extern void (*objc_free)(void *);

#define  OBJC_MALLOC(VAR, TYPE, NUM) \
   ((VAR) = (TYPE *) (*objc_malloc)((unsigned)(NUM)*sizeof(TYPE))) 
#define  OBJC_REALLOC(VAR, TYPE, NUM) \
   ((VAR) = (TYPE *) (*objc_realloc)((VAR), (unsigned)(NUM)*sizeof(TYPE)))
#define  OBJC_CALLOC(VAR, TYPE, NUM) \
   ((VAR) = (TYPE *) (*objc_calloc)((unsigned)(NUM), sizeof(TYPE)))
#define  OBJC_FREE(PTR) (*objc_free)((PTR))

/* GNU Object.[hm] defines -compare:, NeXT doesn't, libcoll needs it. */
#ifdef NeXT
@interface Object (GNUExtensions)
- (int)compare:anotherObject;
- shouldNotImplement:(SEL)op;
@end
#endif /* NeXT */

#endif /* __collstd_h_INCLUDE_GNU */



