/* Support for general purpose definitions for the Collection Library.
   Copyright (C) 1993 Free Software Foundation, Inc.

   Written by:  R. Andrew McCallum <mccallum@cs.rochester.edu>
   Dept. of Computer Science, U. of Rochester, Rochester, NY  14627

   This file is part of the GNU Objective-C Collection library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/ 

/* remove some of these includes */
#include <coll/collstd.h>
#include <stdlib.h>
#include <stdarg.h>
#include <objc/Object.h>
#include <coll/collhash.h>

#define XSTR(s) STR(s)
#define STR(s) #s
const char coll_version[] = XSTR(COLL_VERSION);
const char coll_gcc_version[] = XSTR(COLL_GCC_VERSION);

#ifdef NeXT
const char coll_NeXT_cc_version[] = XSTR(NX_CURRENT_COMPILER_RELEASE)
#endif

/* GNU Object.[hm] defines -compare:, NeXT doesn't, libcoll needs it. */
#ifdef NeXT

@implementation Object (GNUExtensions)
- (int)compare:anotherObject;
{
  if ([self isEqual:anotherObject])
    return 0;
  // Ordering objects by their address is pretty useless, 
  // so subclasses should override this is some useful way.
  else if (self > anotherObject)
    return 1;
  else 
    return -1;
}
- shouldNotImplement:(SEL)op
{
  return [self error:"should not implement %s", sel_getName (op)];
}
@end

#endif /* NeXT */
