/* Demostration application using XmStep: a fileviewer
 *
 * Author: Libing Wang
 */

#include "appkit/Application.h"
#include "appkit/Window.h"
#include "appkit/Matrix.h"
#include "appkit/ScrollView.h"
#include "appkit/NXBrowser.h"
#include "BrowserDelegate.h"


int main(int argc, char **argv)
{
    id                  myBrowser;
    Window             *myWindow;
    NXRect              myFrame;
    NXSize             *outermost;

    [[Application alloc] initargc:argc argv:argv];
    
    myFrame.size.width  = 500;
    myFrame.size.height = 250;
    myFrame.origin.x = 0;
    myFrame.origin.y = 0;
    myWindow = [[Window alloc] initContent:&myFrame];
    [myWindow setTitle:"ObjcX File Viewer"];
    
    myFrame.size.width  = 480;
    myFrame.size.height = 230;
    myFrame.origin.x = 20;
    myFrame.origin.y = 20;
    myBrowser = [[NXBrowser alloc] initFrame:&myFrame];
    [myBrowser setMinColumnWidth:160];
    [myBrowser setMaxVisibleColumns:3];
// The following is not enabled because ScrollView is not correct
//    [myBrowser setHorizontalScrollerEnabled:YES];
    
    [myBrowser setDelegate:[[BrowserDelegate alloc] init]];
    [myBrowser setTarget:[myBrowser delegate]];
    [myBrowser setDoubleAction:@selector(execute:)];

    [[myWindow contentView] addSubview:myBrowser];
    [myBrowser loadColumnZero];
    [myWindow orderFront:nil];
    
    [NXApp run];
    [NXApp free];
}
