/*  Archiving Category for IBControlConnector and IBOutletConnector
    Copyright (C)  1993  The Board of Trustees of
    The Leland Stanford Junior University.  All Rights Reserved.

Authors: Paul Kunz and Imran Qureshi

 * This file is part of the nib translator for 
 * an Objective-C class library for X/Motif

XmConnector.m,v 1.5 1994/06/11 03:53:20 pfkeb Exp

*/

#include "XmConnector.h"
#include <stdio.h>
#include <stdlib.h>

@implementation IBConnector (XmArchiving)
- write:(TypedStream *)stream
{
	[super write:stream];

#ifdef DEBUG
    printf("->IBConnector");
#endif

	objc_write_object_reference(stream,source);
	objc_write_object_reference(stream,destination);
	objc_write_type(stream,"*",(char *)label);
	return self;
}
@end

@implementation IBControlConnector (XmArchiving)
- write:(TypedStream *)stream
{
    [super write:stream];

#ifdef DEBUG
    printf("->IBControlConnector");
#endif

    return self;
}

- establishConnection
{
#ifdef DEBUG
    printf("Control connection: ");
    printf("src = %p ", source);
    printf("dst = %p ", destination);
    printf("action = %s\n", (char *)label);
#endif
    return self;
}
 /*Do not let NeXTStep free this connectors */
- free
{
	return self;
}
@end

@implementation IBOutletConnector (XmArchiving)
- write:(TypedStream *)stream
{
    [super write:stream];

#ifdef DEBUG
    printf("->IBOutletConnector");
#endif
    return self;
}

- establishConnection
{
#ifdef DEBUG
    printf("Outlet connection ");
    printf("src = %p ", source);
    printf("dst = %p ", destination);
    printf("outlet = %s\n", (char *)label);
#endif
    return self;
}
 /*Do not let NeXTStep free this connectors */
- free
{
	return self;
}
@end
