/*  Archiving Category for Matrix
    Copyright (C)  1993  The Board of Trustees of
    The Leland Stanford Junior University.  All Rights Reserved.

Authors: Paul Kunz, Imran Qureshi and Libing Wang

 * This file is part of the nib translator for 
 * an Objective-C class library for X/Motif

XmMatrix.m,v 1.11 1994/06/11 03:53:37 pfkeb Exp

*/

#include "/NextDeveloper/Headers/objc/typedstream.h"
#include "/NextDeveloper/Headers/objc/Object.h"

#define NXTypedStream TypedStream
#include <appkit/Matrix.h>

@interface Matrix (XmArchiving)
- write:(TypedStream *)stream;
@end

#include "archive-def.h"

@implementation Matrix (XmArchiving)
- write:(TypedStream *)stream
{
    char                cellClassName[64];
    int			mode;

    [super write:stream];
    
#ifdef DEBUG
    printf("->Matrix");
#endif

    objc_write_object(stream, cellList);

    if ( cellClass ) {
        strcpy(cellClassName,[cellClass name]);
    } else {
        cellClassName[0] = '\0';
    }
    objc_write_type(stream, "*", cellClassName );
    objc_write_object(stream, protoCell);

    objc_write_float(stream, &(cellSize.width));
    objc_write_float(stream, &(cellSize.height));
    objc_write_types(stream, "ii", &numRows, &numCols);
    objc_write_types(stream, "ii", &selectedRow, &selectedCol);
    mode = mFlags.radioMode;
    objc_write_type(stream, "i", &mode);

    return self;
}
@end
