/*  Archiving Category for NXBrowser
    Copyright (C)  1993  The Board of Trustees of
    The Leland Stanford Junior University.  All Rights Reserved.

Authors: Paul Kunz, Imran Qureshi and Libing Wang

 * This file is part of the nib translator for 
 * an Objective-C class library for X/Motif

XmNXBrowser.m,v 1.6 1994/06/11 03:53:42 pfkeb Exp

*/


#include "/NextDeveloper/Headers/objc/typedstream.h"
#include "objc/typedstream.h"
#define NXTypedStream TypedStream
#include <appkit/NXBrowser.h>


@interface NXBrowser (XmArchiving)
- write:(TypedStream *)stream;
@end

@implementation NXBrowser (XmArchiving)

- write:(TypedStream *)stream
{
    int                 titleHeight;
    const char         *stringCol1;
    BOOL                hasHorizontalScroller = NO;
    BOOL                isTitled = NO;

    if ((isTitled = [self isTitled])) {
	stringCol1 = [self titleOfColumn:0];
	titleHeight = [self titleHeight];
    }
 /*
  * Before invoking the superview, get rid of subviews 
  */
    hasHorizontalScroller = [self isHorizontalScrollerEnabled];
    [subviews freeObjects];
    [subviews free];
    subviews = nil;

    [super write:stream];

#ifdef DEBUG
    printf("->NXBrowser");
#endif

    objc_write_types(stream, "cc", &hasHorizontalScroller, &isTitled);
    objc_write_type(stream, "s", &_reserved4[2]);	/* number of columns */
    if (isTitled) {
	objc_write_types(stream, "i*", &titleHeight, &stringCol1);
    }
    return self;
}
@end




