/*  Archiving Category for Slider
    Copyright (C)  1993  The Board of Trustees of
    The Leland Stanford Junior University.  All Rights Reserved.

Authors: Scott Francis, Paul Kunz, Imran Qureshi, and Libing Wang

 * This file is part of the nib translator for 
 * an Objective-C class library for X/Motif

XmSlider.m,v 1.8 1994/06/11 03:54:02 pfkeb Exp

*/


#include "/NextDeveloper/Headers/objc/typedstream.h"
#include "objc/typedstream.h"

#include "XmControl.h"
#include <appkit/Slider.h>


@interface Slider (XmArchiving)
- convertCoordToMotif:sender;
- write:(TypedStream *)stream;
@end

#ifdef DEBUG
#include <stdio.h>
#endif

@implementation Slider (XmArchiving)

- convertCoordToMotif:sender
{
    [super convertCoordToMotif:sender];
 /* adjust dimensions so that un-selected widget is same as NeXT object */
    frame.origin.x    -= 2;
    frame.origin.y    -= 2;
    frame.size.height += 4; /* can't seem to make it one pixel higher */
    frame.size.width  += 4;
    return self;
}

- write:(TypedStream *)stream
{
    [super write:stream];
    
#ifdef DEBUG
    printf("\n->Slider");
#endif

    return self;
}
@end
