/* Archiving Category for Window
 *
 * Copyright (C)  1993  The Board of Trustees of
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, Imran Qureshi, and Libing Wang
 *
 * This file is part of the nib translator for 
 * an Objective-C class library for X/Motif
 *
 * XmWindow.m,v 1.14 1994/06/11 03:54:14 pfkeb Exp
 */

#include "/NextDeveloper/Headers/objc/typedstream.h"
#include "/NextDeveloper/Headers/objc/Object.h"
#include <stdio.h>
#include <stdlib.h>

#define NXTypedStream TypedStream
#include <appkit/Window.h>

@interface Window (XmArchiving)
- convertCoordToMotif:sender;
- write:(TypedStream *)stream;
@end

#include "archive-def.h"

@implementation Window (XmArchiving)

/* only window should really send a message down to convert Coords */
- convertCoordToMotif:sender
{
    return [contentView convertCoordToMotif:self];
}

- write:(TypedStream *)stream
{
    BOOL	isVisible;

    [super write:stream];
   
#ifdef DEBUG
    printf("->(Window = %s)", [self title]);
#endif

    objc_write_rect(stream, &frame);
    objc_write_string(stream,[self title], strlen([self title]) + 1);
    objc_write_object(stream, contentView);

    isVisible = [self isVisible];
    objc_write_type( stream, "c", &isVisible);
    return self;
}

@end
