/* Extensions to objc/typedstream.h
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Copyright (C) 1993 Keith Mason. All Rights Reserved.
 *
 * Author: Keith Mason
 *
 * This file is part of an Objective-C class library for a window system
 *
 * typedstream2.h,v 1.6 1994/05/11 18:23:48 pfkeb Exp
 */

 
#ifndef _TYPED_STREAM_2_
#define _TYPED_STREAM_2_

#include <streams/streams.h>
#include "objc/typedstream.h"

/* TypedStream to NXTypedStream translations; these may need to be changed   */
/* when using a non-GNU version of Obj-C (deleted, if using NeXT native cc)  */

/* Do these three exist in NeXT?  They're here just in case. */
#define NX_MANAGED_STREAM OBJC_MANAGED_STREAM
#define NX_FILE_STREAM    OBJC_FILE_STREAM
#define NX_MEMORY_STREAM  OBJC_MEMORY_STREAM

#define NXTypedStream TypedStream

#define NXWriteType               objc_write_type
#define NXReadType                objc_read_type

#define NXWriteTypes              objc_write_types
#define NXReadTypes               objc_read_types

#define NXWriteObjectReference    objc_write_object_reference
#define NXWriteRootObject         objc_write_root_object

#define NXTypedStreamClassVersion objc_get_stream_class_version

#define NXWriteArray              objc_write_array
#define NXReadArray               objc_read_array

#define NXWriteObject             objc_write_object

#define NXOpenTypedStream         objc_open_typed_stream
#define NXOpenTypedStreamForFile  objc_open_typed_stream_for_file

#define NXCloseTypedStream        objc_close_typed_stream

#define NXEndOfTypedStream        objc_end_of_typed_stream
#define NXFlushTypedStream        objc_flush_typed_stream

/*  Thsi should be removed when float writing works !! */
#define objc_read_float(stream,floatPtr) \
 { objc_read_int(stream,((int *)(floatPtr)));}

/* The following should be fixed when floating works */
#define objc_read_rect(stream,rectPtr) \
 { objc_read_int(stream,(&((rectPtr)->origin.x))); \
 	objc_read_int(stream,(&((rectPtr)->origin.y))); \
	objc_read_int(stream,(&((rectPtr)->size.width))); \
	objc_read_int(stream,(&((rectPtr)->size.height))); \
	}

/* This one was missing.  It needs to be changed, anyway, as the calling
 * style is different.
 */
extern int objc_read_object (TypedStream* stream, id* object);

static inline id NXReadObject(NXTypedStream *stream)
{
  id i;
  objc_read_object(stream, &i);
  return i;
}

#endif /* _TYPED_STREAM_2_ */
